% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-ipums-read.R
\name{read_ipums_sp}
\alias{read_ipums_sp}
\title{Read boundary (GIS) files from an IPUMS extract}
\usage{
read_ipums_sp(
  shape_file,
  shape_layer = NULL,
  vars = NULL,
  encoding = NULL,
  bind_multiple = TRUE,
  add_layer_var = NULL,
  verbose = TRUE
)
}
\arguments{
\item{shape_file}{Path to a single .shp file or a .zip archive
containing at least one .shp file. See Details section.}

\item{shape_layer}{If \code{shape_file} contains multiple files, an expression
identifying the files to load. Accepts a character string specifying the
file name, a \link[=selection_language]{tidyselect selection}, or index
position. If multiple files are selected, \code{bind_multiple} must be equal
to \code{TRUE}.}

\item{vars}{Names of variables to include in the output. Accepts a
character vector of names or a \link[=selection_language]{tidyselect selection}.
If \code{NULL}, includes all variables in the file.}

\item{encoding}{Encoding to use when reading the shape file. If \code{NULL},
defaults to \code{"latin1"} unless the file includes a .cpg metadata file
with encoding information. The default value should generally be
appropriate.}

\item{bind_multiple}{If \code{TRUE} and \code{shape_file} contains multiple .shp files,
row-bind the files into a single output. Note that some data sources may
not be able to be combined (e.g. \code{SpatialPolygonsDataFrame} and
\code{SpatialPointsDataFrame}).}

\item{add_layer_var}{If \code{TRUE}, add a variable to the output data indicating
the file that each row originates from. Defaults to \code{FALSE} unless
\code{bind_multiple = TRUE} and multiple files exist in \code{shape_file}.

The column name will always be prefixed with \code{"layer"}, but will be
adjusted to avoid name conflicts if another column named \code{"layer"} already
exists in the data.}

\item{verbose}{If \code{TRUE}, report progress information.}
}
\value{
A \code{SpatialPolygonsDataFrame} or \code{SpatialPointsDataFrame} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Read spatial data from an IPUMS extract into R using the \code{sp} package.

This function has been deprecated because of the upcoming retirement
of the rgdal package. For more information, click
\href{https://r-spatial.org/r/2022/04/12/evolution.html}{here}.

Please use \code{\link[=read_ipums_sf]{read_ipums_sf()}} to load spatial data from IPUMS. To convert
to a \code{SpatialPolygonsDataFrame}, use \code{\link[sf:coerce-methods]{sf::as_Spatial()}}.
}
\details{
Some IPUMS products provide shapefiles in a "nested" .zip archive. That is,
each shapefile (including a .shp as well as accompanying files) is
compressed in its own archive, and the collection of all
shapefiles provided in an extract are also compressed into a single .zip
archive.

\code{read_ipums_sp()} is designed to handle this structure. However, if an
internal .zip archive happens to contain \emph{multiple} shapefiles, this function
will throw an error. If this is the case, you may need to manually unzip the
downloaded file before loading it into R.
}
\examples{
shape_file <- ipums_example("nhgis0972_shape_small.zip")

# If sp package is available, can load as SpatialPolygonsDataFrame
if (require(sp) && require(rgdal)) {
  sp_data <- read_ipums_sp(shape_file, verbose = FALSE)
}
}
\keyword{internal}
