% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ar1_sim_consecutive}
\alias{ar1_sim_consecutive}
\title{Simulate from a stationary Gaussian AR(1) process.}
\usage{
ar1_sim_consecutive(n, rho, sigma, mu = 0)
}
\arguments{
\item{n}{The number of timepoints to simulate for.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}

\item{mu}{A vector of expected values with length \code{n}, or a scalar
(default equal to 0).}
}
\value{
A vector of length \code{n} with the process values.
}
\description{
Simulate from a stationary Gaussian AR(1) process at \code{n} consecutive
time points.
}
\examples{
n <- 10
rho <- 0.5
sigma <- 1
mu <- 1:10
ar1_sim_consecutive(n, rho, sigma)
ar1_sim_consecutive(n, rho, sigma, mu)
}
