% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dprecchol_drho}
\alias{dprecchol_drho}
\title{Derivative of the upper Cholesky triangle of the precision matrix of a
stationary Gaussian AR(1) process.}
\usage{
dprecchol_drho(U, dQ)
}
\arguments{
\item{U}{The upper Cholesky triangle of the precision matrix \code{Q} of the
AR(1) process.}

\item{dQ}{The derivative of the precision matrix \code{Q} with respect to
the correlation parameter \code{rho}.}
}
\value{
A band 1 upper triangular matrix of the same dimensions as \code{U}.
}
\description{
Creates the derivate of the upper Cholesky triangle of the precision matrix
of an AR(1) process with respect to the parameter \code{rho}.
}
\examples{
library(Matrix)
t <- c(1, 3:4, 6, 8)
r <- 0.5
s <- 1
U <- ar1_prec_chol_irregular(t, r, s)
dQ <- dprec_drho(t, r, s)
(dU <- dprecchol_drho(U, dQ))
}
