% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot_empirical_icc}
\alias{plot_empirical_icc}
\title{Plot Empirical Item or Test characteristic curve}
\usage{
plot_empirical_icc(
  resp,
  item,
  type = "eicc",
  bins = 10,
  ip = NULL,
  theta = NULL,
  title = "",
  suppress_plot = FALSE,
  x_axis_scale = NULL,
  n_dodge = 1,
  ...
)
}
\arguments{
\item{resp}{Response matrix.}

\item{item}{The column number, column name or the 'id' of the  the item that
should be plotted.}

\item{type}{The type of the graph that will be plotted.
\describe{
  \item{\strong{\code{"eicc"}}}{Plot empirical item characteristic curve.
    Examinees will be put into bins based on their total raw scores and the
    proportion of examinees who correctly answered an item for each bin
    will be plotted.}
  \item{\strong{"oep"}}{Plot Observed p-values vs. expected p-values
    grouped into bins based on total raw scores or theta scores.
    This plot requires an \code{\link{Itempool-class}} object.
    Optionally, provide \code{theta} vector, otherwise examinee abilities
    will be estimated by \code{est_ability(..., type = "eap")}. This will
    slow down the plotting function.
  }
}}

\item{bins}{An integer larger than 2 representing of ability groups examinees
should be grouped into. The default is \code{10}. The maximum value of
\code{bins +  1} is the number of possible total scores.}

\item{ip}{An \code{\link{Itempool-class}} object that is needed for some
plots.}

\item{theta}{A vector of examinee abilities.}

\item{title}{Title of the plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{x_axis_scale}{Set the scale of the x-axis. The default value is
  \code{NULL}. For total score it will be defaulted to \code{"percent"}.
  \describe{
    \item{\strong{\code{"percent"}}}{Percent interval.}
    \item{\strong{\code{"number"}}}{Numbers between 1 and \code{bins}}
    \item{\strong{\code{"theta"}}}{Theta values equally divided into bins.
    the middle value of the bin is shown in the x-axis. For example, if
    \code{bins = 10}, the first tick of the x-axis will be the mean of
    minimum theta value and tenth percentile theta value.

    This is the only option for \code{type = "oep"}. }
    }}

\item{n_dodge}{The number of lines the x-axis tick labels should be written
to. This is especially useful if the x-axis tick labels overlap with each
other. The default value is \code{1}, which means all of the labels are
written on the same line.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the empirical item or test characteristic curve or returns the plot object.
}
\description{
\code{plot_emprical_icc} plots empirical item or test characteristic curve.
}
\examples{
# Plot the information function of an item
resp <- sim_resp(ip = generate_ip(model = "3PL", n = 20),
                 theta = rnorm(10000))
plot_empirical_icc(resp, 3)
# Change the number of bins
plot_empirical_icc(resp, 4, bins = 15)

}
\author{
Emre Gonulates
}
