% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_set-class-methods.R
\name{[,Response_set,ANY,missing-method}
\alias{[,Response_set,ANY,missing-method}
\title{Subset \code{Response_set} objects}
\usage{
\S4method{[}{Response_set,ANY,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{A \code{\link{Response_set-class}} object from which to extract
element(s) or in which to replace element(s).}

\item{i}{indices specifying elements to extract or replace.}

\item{j}{This will not be used in \code{\link{Response_set-class}} objects.}

\item{...}{Parameters to be passed to the function.}

\item{drop}{(From R manual:) For matrices and arrays. If TRUE the result is
coerced to the lowest possible dimension (see the examples). This only works
for extracting elements, not for the replacement. See drop for further
details.}
}
\value{
An \code{\link{Response_set-class}} object.
}
\description{
Subset \code{Response_set} objects
}
\examples{
resp_set <- sim_resp(ip = generate_ip(n = 12), theta = rnorm(10),
                     output = "response_set")
resp_set[1]
# Create an Response_set using the first and third element:
resp_set[c(1, 3)] # Order is important
resp_set[c(3, 1)]
resp_set[-2]
resp_set[c(TRUE, FALSE, TRUE)]
resp_set[c("S2", "S1")]
# Recycle, i.e. get all elements
resp_set[TRUE]
# Recycle, i.e. get all even elements
resp_set[c(FALSE, TRUE)]

# Use logical expressions
resp_set[resp_set$examinee_id \%in\% c("S3", "S8")]
}
\author{
Emre Gonulates
}
\keyword{internal}
