% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/person_fit.R
\name{cusum_single}
\alias{cusum_single}
\title{CUSUM based statistics for one examinee}
\usage{
cusum_single(ip, resp, theta = NULL, method = "T1", initial_theta_est = NULL)
}
\arguments{
\item{ip}{An \code{\link{Itempool-class}} object}

\item{resp}{a response vector, where the order of items represent the
administration order.}

\item{theta}{A vector or length 1 or length equal to the number of items
administered.}

\item{method}{Method of calculating the CUSUM statistic. Choices are:
\code{"T1"}, \code{"T2"}, \code{"T3"}, \code{"T4"}, \code{"T5"},
\code{"T6"}, \code{"T7"} and \code{"T8"}. \code{"T1"} through \code{"T4"}
uses the ability estimate each stage of the test. \code{"T5"} through
\code{"T8"} uses the final ability estimate and needs only one theta
estimate.}

\item{initial_theta_est}{For CAT, the initial theta estimate of an examinee.
  For CAT, if \code{theta = NULL}, this initial theta estimate will be used
  to calculate \eqn{T_1}, \eqn{C^-_1} and \eqn{C^+_1}. For CAT, this value
  should be provided. By this way for the calculation of \eqn{T_1},
  \eqn{C^-_1} and \eqn{C^+_1}, \eqn{\hat \theta_{n-1}} will be used.

  If it's value is  \code{NULL} and \code{theta = NULL}, then for the
  calculation of \eqn{T_1}, \eqn{C^-_1}  and \eqn{C^+_1},
  \eqn{\hat \theta_{n}} will be used.

  The default value is \code{NULL}}
}
\value{
The function will return a data frame consist of two columns:
  \code{Cp} column for \eqn{C^+} values and \code{Cn} column for \eqn{C^-}
  values.
}
\description{
CUSUM based statistics for one examinee
}
\examples{
# Example from Table 1 (p.4) of Yu and Cheng (2020):
ip <- itempool(a = c(0.976, 0.973, 0.871, 0.768, 0.94, 1.109, 1.063, 0.888,
                     0.648, 0.733, 0.8, 0.823, 0.611, 0.965, 1.052, 0.937,
                     0.894, 0.72, 0.686, 0.608),
               b = c(-0.693, 0.6, -0.607, -0.637, -1.095, -0.202, -0.679,
                     0.058, -0.822, -0.768, -0.737, -1.158, -0.294, -0.856,
                     -0.833, -0.613, -0.151, -0.614, -0.07, -0.806),
               c = c(0.371, 0.224, 0.159, 0.377, 0.159, 0.146, 0.181, 0.251,
                     0.179, 0.214, 0.312, 0.224, 0.246, 0.225, 0.155, 0.166,
                     0.456, 0.327, 0.112, 0.169),
               D = 1.7)
resp <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1)
theta <- -0.06

cusum_single(ip, resp, theta, method = "T5")

}
\references{
van Krimpen-Stoop, E. M. L. A., & Meijer, R. R. (2000). Detecting
  person-misfit in adaptive testing using statistical process control
  techniques. In W. J. van der Linden & C. A. W. Glas (Eds.),
  Computerized adaptive testing: Theory and practice (pp. 210–219).
  Kluwer.

Xiaofeng Yu & Ying Cheng (2020): A Comprehensive Review and Comparison of
  CUSUM and Change-Point-Analysis Methods to Detect Test Speededness,
  Multivariate Behavioral Research, <doi:10.1080/00273171.2020.1809981>
}
\author{
Emre Gonulates
}
