% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim.R
\name{cat_sim}
\alias{cat_sim}
\title{Computerized Adaptive Test (CAT) Simulation}
\usage{
cat_sim(true_ability, cd, verbose = -1)
}
\arguments{
\item{true_ability}{True ability vector to generate item responses.}

\item{cd}{A \code{cat_design} object that is created by function
\code{create_cat_design}.}

\item{verbose}{This is an integer that will print the stage of the test.
For example, if the value verbose = 10, a message will be printed at
each tenth iteration of the cat_simulation. Default value is \code{-1},
where no message will be printed. If the value is \code{0}, only the
start time and end time of the simulation will be printed.}
}
\value{
If the length of \code{true_ability} vector is one a
  \code{"cat_output"} class output will be returned.
  This is a list containing following elements:
  \describe{
    \item{true_ability}{True ability (theta) value to generate item
      responses.}
    \item{est_history}{A list where each element represent a step of the
      CAT test. It has following elements:
      \describe{
        \item{est_before}{The estimated ability before the administration
          of the item. }
        \item{se_before}{The standard error of the estimated ability before
          the administration of the item. }
        \item{testlet}{\code{TRUE} if the item belongs to a testlet.}
        \item{item}{\code{\link{Item-class}} object that is administered at
          this step.}
        \item{resp}{The simulated response of the simulee for the item
          administered at this step using simulee's \code{true_ability}
          value.}
        \item{est_after}{The estimated ability after the administration
          of the item.}
        \item{se_after}{The standard error of the estimated ability after
          the administration of the item. }
       }
    }
  }

  If the length of the \code{true_ability} is more than 1, a list of
  \code{cat_output} objects will be returned for each value of
  \code{true_ability}.
}
\description{
\code{cat_sim} function simulates computerized adaptive test (CAT) for
one or more simulees. For long simulations, \code{\link{cat_sim_fast}}
function can be used.
}
\examples{
ip <- generate_ip(n = 50)
# Check the default:
cd <- create_cat_design(ip = ip)
cat_sim(true_ability = rnorm(1), cd = cd)

# Multiple theta, optionally set names to the the vector to give examinee IDs
true_theta <- setNames(c(-2, 0.4, 1.5), c("Jimmy", "Ali", "Mirabel"))
cd <- create_cat_design(
  ip = ip,
  ability_est_rule = 'ml',
  termination_rule = c('min_item', 'min_se', 'max_item'),
  termination_par = list(min_item = 10, min_se = .33, max_item = 20))
cat_sim(true_ability = true_theta, cd = cd)
}
\seealso{
\code{\link{create_cat_design}}
}
\author{
Emre Gonulates
}
