% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llike_score.R
\name{llike_score}
\alias{llike_score}
\title{Loglikelihood of Ability Parameters}
\usage{
llike_score(
  x,
  data,
  theta,
  D = 1,
  method = "ML",
  norm.prior = c(0, 1),
  fence.a = 3,
  fence.b = NULL,
  missing = NA
)
}
\arguments{
\item{x}{A data frame containing the item metadata (e.g., item parameters, number
of score categories, models). This can be created easily using the \code{\link{shape_df}}
function. See \code{\link{est_irt}}, \code{\link{irtfit}}, \code{\link{info}},
or \code{\link{simdat}} for more details about the item metadata.}

\item{data}{A matrix representing examinees' response data for the items in \code{x}.
Each row and column corresponds to an examinee and an item, respectively.}

\item{theta}{A numeric vector of ability parameters for which the loglikelihood
values will be computed.}

\item{D}{A scaling factor in IRT models that adjusts the logistic function to
approximate the normal ogive function (set to 1.7). The default is 1.}

\item{method}{A character string specifying the scoring method. Options include
"ML" for maximum likelihood estimation,  "MLF" for maximum likelihood estimation
with fences, and "MAP" for maximum a posteriori estimation. The default method is "MLE".}

\item{norm.prior}{A numeric vector of two elements indicating the mean and standard
deviation of the normal prior distribution. These parameters are used to obtain
the Gaussian quadrature points and corresponding weights from the normal distribution.
Default is c(0,1). This parameter is ignored if \code{method} is "ML" or "MLF".}

\item{fence.a}{A numeric value defining the item slope parameter (a-parameter) for
the two imaginary items in the MLF method. Default is 3.0.}

\item{fence.b}{A numeric vector of two elements specifying the lower and upper fences
of item difficulty parameters (b-parameters) for the two imaginary items in the MLF method.
If \code{fence.b = NULL}, the \code{range} values are used to set the fences.
The default is NULL.}

\item{missing}{A value used to denote missing values in the response data set. Default is NA.}
}
\value{
A data frame of loglikelihood values. Each row indicates the ability parameter
for which the loglikelihood was computed, and each column represents a response pattern.
}
\description{
This function computes the loglikelihood of ability parameters
given the item parameters and response data.
}
\details{
The function computes the loglikelihood value of the ability parameter given
the item parameters and response data for each item. As an example, to assess the loglikelihoods
of abilities for two examinees who have taken the same test items specified in \code{x}, supply
their item response data matrix with two rows in \code{data} and a vector of ability values
for which loglikelihood needs to be computed in \code{theta}.
}
\examples{
## Import the "-prm.txt" output file from flexMIRT
flex_sam <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# Read item parameters and transform them into item metadata
x <- bring.flexmirt(file=flex_sam, "par")$Group1$full_df

# Generate examinees' abilities from N(0, 1)
set.seed(10)
score <- rnorm(5, mean=0, sd=1)

# Simulate the response data
data <- simdat(x=x, theta=score, D=1)

# Specify the ability values for which the loglikelihood values will be computed
theta <- seq(-3, 3, 0.5)

# Compute the loglikelihood values (using the MLE method)
llike_score(x=x, data=data, theta=theta, D=1, method="ML")

}
