% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/da_mle_cedp.R
\name{mss_cedp}
\alias{mss_cedp}
\title{Likelihood approach for esitmating colonization/extinction with perfect or imperfect detectability}
\usage{
mss_cedp(Data, Time, Factor, Tags, Colonization = 1, Extinction = 1,
  Detectability_Value = 0.5, Phi_Time_0_Value = 0.5, Tol = 1e-08,
  MIT = 100, C_MAX = 10, C_min = 0, E_MAX = 10, E_min = 0,
  D_MAX = 0.99, D_min = 0, P_MAX = 0.99, P_min = 0.01, I_0 = 0,
  I_1 = 1, I_2 = 2, I_3 = 3, z = 2, Minimization = 1,
  Verbose = 0, MV_FLAG = 0.1, PerfectDetectability = TRUE)
}
\arguments{
\item{Data}{data frame containing presence data per time (in cols) and sites (in rows)}

\item{Time}{an array of length n containing increasing sampling times}

\item{Factor}{column number containing the 'data frame' factor used to split total data into level-based groups}

\item{Tags}{array of names (one short for each level of the factor analyzed)}

\item{Colonization}{guess value to initiate search / parameter value}

\item{Extinction}{guess value to initiate search / parameter value}

\item{Detectability_Value}{guess value to initiate search / parameter value}

\item{Phi_Time_0_Value}{guess value to initiate search / parameter value}

\item{Tol}{stopping criteria of the search algorithm.}

\item{MIT}{max number of iterations of the search algorithm.}

\item{C_MAX}{max value for the possible range of colonization values}

\item{C_min}{min value for the possible range of colonization values}

\item{E_MAX}{max value for the possible range of colonization values}

\item{E_min}{min value for the possible range of colonization values}

\item{D_MAX}{max value for the possible range of colonization values}

\item{D_min}{min value for the possible range of colonization values}

\item{P_MAX}{max value for the possible range of colonization values}

\item{P_min}{min value for the possible range of colonization values}

\item{I_0}{has to be 0 or 1. Defaults to 0}

\item{I_1}{has to be 0 or 1. Defaults to 1}

\item{I_2}{has to be 0, 1, 2, or 3. Defaults to 2}

\item{I_3}{has to be 0, 1, 2, or 3. Defaults to 3}

\item{z}{dimension of the parameter subspace for which the optimization process will take place. Defaults to 2}

\item{Minimization, }{1/0. If Minimization is 0, then no minimization is performed.}

\item{Verbose}{more/less (1/0) information about the optimization algorithm will be printed out.}

\item{MV_FLAG}{missing Value Flag (to specify sites and times where no sample exists)}

\item{PerfectDetectability}{TRUE means 'Perfect Detectability'. Of course, FALSE means 'Imperfect Detectability'}
}
\description{
\code{mss_cedp} conducts maximum likelihood estimation of colonization/extinction parameters
of different data sets. This function can handle imperfect detectability and missing data
defining a heterogeneous sampling structure across input data matrix rows. The function generates,
as an output, either a 3-column matrix (Colonization, Extinction, Negative LogLikelihood) or
5-column matrix (Colonization, Extinction, Detectability, P_0, Negative LogLikelihood), depending
on the value of the input parameter PerfectDetectability (either \code{TRUE} or \code{FALSE}).
}
\details{
The input is a data frame containing presence data per time (in cols).  Different factors (for instance,
OTU, location, etc) can slide the initial data frame accordingly. Model parameters will be estimated
for each of these groups independently that correspond to each level of the chosen factor. If Minimization
is 0, then no maximum likelihood estimation is performed and only the likelihood evaluation at the input model
parameter values is returned. Searches are based on the Nelder-Mead simplex method, but conducted in a
bounded parameter space which means that in case a neg loglikelihood (NLL) evaluation is called out from these
boundaries, the returned value for this NLL evaluation is artifically given as the maximum number the machine can
hold. Each group is named by a short-length-character label (ideally, 3 or 4 characters). All labels should
have the same character length to fulfill memmory alignment requirements of the shared object called by
.C(...) function. I_0, I_1, I_2, I_3 are model parameter keys. They are used to define a 4D-vector (Index). The
search will take place on the full parameter space defined by model parameters (I_0, I_1) if PefectDetectability
is \code{TRUE} or, alternatively, defined by (I_0, I_1, I_2, I_3) if PerfectDetectability is \code{FALSE}.
Model parameter keys correspond to colonization (0), extinction (1), detectability (2), and P_0 (3) model
parameters. For instance, if (I_0, I_1) is (1, 0), the search will take place whitin the paremeter space defined
by extinction, as the first axis, and colonization, as the second.
}
\examples{
\dontrun{
Data <- lakshadweepPLUS[[1]]
Guild_Tag = c("Alg", "Cor", "Mac", "Mic", "Omn", "Pis", "Zoo")
Time <- as.vector(c(2000, 2000, 2001, 2001, 2001, 2001, 2002, 2002, 2002,
2002, 2003, 2003, 2003, 2003, 2010, 2010, 2011, 2011, 2011, 2011, 2012,
2012, 2012, 2012, 2013, 2013, 2013, 2013))
R <- mss_cedp(Data, Time, Factor = 3, Tags = Guild_Tag,
PerfectDetectability = FALSE, z = 4)
Guild_Tag = c("Agt", "Kad", "Kvt")
R <- mss_cedp(Data, Time, Factor = 2, Tags = Guild_Tag,
PerfectDetectability = FALSE, z = 4)
}
}
