% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-doc.R
\docType{data}
\name{Prostate}
\alias{Prostate}
\title{Prostate Cancer Data}
\format{
A data frame with 97 observations and 9 variables:
\describe{
  \item{lcavol}{Log of cancer volume}
  \item{lweight}{Log of prostate weight}
  \item{age}{Age of the patient}
  \item{lbph}{Log of benign prostatic hyperplasia amount}
  \item{svi}{Seminal vesicle invasion (binary)}
  \item{lcp}{Log of capsular penetration}
  \item{gleason}{Gleason score}
  \item{pgg45}{Percentage of Gleason scores 4 or 5}
  \item{lpsa}{Log of prostate-specific antigen}
}
}
\source{
Stamey, T.A., et al. (1989).
Prostate specific antigen in the diagnosis and treatment of adenocarcinoma of the prostate: II. radical prostatectomy treated patients.
Journal of Urology, 141(5), 1076-1083.
}
\description{
This dataset originates from a study examining the correlation between prostate-specific antigen levels and various clinical measures in men scheduled for radical prostatectomy.
It contains 97 rows and 9 variables.
}
\examples{
data(Prostate)
summary(Prostate)
cor(Prostate$lpsa, Prostate$lcavol)
\dontrun{
  fit <- islasso(lpsa ~ ., data = Prostate, family = gaussian())
  summary(fit, pval = 0.05)
  lambda.aic <- aic.islasso(fit, method = "AIC")
  fit.aic <- update(fit, lambda = lambda.aic)
  summary(fit.aic, pval = 0.05)
}

}
\references{
Stamey, T.A., Kabalin, J.N., McNeal, J.E., Johnstone, I.M., Freiha, F., Redwine, E.A., and Yang, N. (1989).
Journal of Urology, 141(5), 1076-1083.
}
\keyword{datasets}
