### * None of the functions in this file is exported

### * describe_z_eta()

#' Print a message describing the role of eta or zeta in a distribution family
#'
#' @param param_name Name of the parameter (e.g. "eta" or "zeta").
#' @param family Family string.
#' @param prefix,suffix Strings appended to the message.
#'
#' @keywords internal
#' @noRd

describe_z_eta <- function(param_name, family, prefix = "  (", suffix = ")") {
    msg <- list(
        "gamma_cv" = " is the coefficient of variation of gamma distributions.",
        "normal_cv" = " is the coefficient of variation of normal distributions.",
        "normal_sd" = " is the standard deviation of normal distributions.",
        "beta_phi" = " is the precision (phi) of beta distributions.")
    if (!family %in% names(msg)) {
        stop("The provided value for the family argument is not allowed.")
    }
    message(prefix, param_name, msg[[family]], suffix, sep = "")
}
