% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inspect_random.R
\name{inspect_random}
\alias{inspect_random}
\title{Inspection of random factor smooths.}
\usage{
inspect_random(model, select = 1, fun = NULL, cond = NULL, n.grid = 30,
  print.summary = getOption("itsadug_print"), plot = TRUE, add = FALSE,
  main = NULL, xlab = NULL, ylab = NULL, ylim = NULL, h0 = 0,
  v0 = NULL, col = NULL, eegAxis = FALSE, ...)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{select}{A number, indicating the model term to be selected.}

\item{fun}{A string or function description to apply to the random effects
estimates. When NULL (default), the estimates for the random effects are
returned.}

\item{cond}{A named list of the values to restrict the estimates for the
random predictor terms. When NULL (default) all levels are returned.}

\item{n.grid}{Number of data points estimated for each random smooth.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor.
Default set to the print info messages option
(see \code{\link{infoMessages}}).}

\item{plot}{Logical: whether or not to plot the random effect estimates
(TRUE by default).}

\item{add}{Logical: whether or not to add the random effect estimates
to an existing plot (FALSE by default).}

\item{main}{Changing the main title for the plot, see also title.}

\item{xlab}{Changing the label for the x axis,
defaults to a description of x.}

\item{ylab}{Changing the label for the y axis,
defaults to a description of y.}

\item{ylim}{Changing the y limits of the plot.}

\item{h0}{A vector indicating where to add solid horizontal lines
for reference. By default 0.}

\item{v0}{A vector indicating where to add dotted vertical lines
for reference. By default no values provided.}

\item{col}{Specifying the colors of the lines.}

\item{eegAxis}{Whether or not to reverse the y-axis
(plotting negative upwards).}

\item{...}{other options to pass on to \code{\link[graphics]{lines}},
see \code{\link[graphics]{par}}}
}
\value{
A data frame with estimates for random effects
is optionally returned.
}
\description{
Inspection of random factor smooths.
}
\examples{
# load data:
data(simdat)

\dontrun{
# Condition as factor, to have a random intercept
# for illustration purposes:
simdat$Condition <- as.factor(simdat$Condition)

# Model with random effect and interactions:
m2 <- bam(Y ~ s(Time) + s(Trial)
+ ti(Time, Trial)
+ s(Condition, bs='re')
+ s(Time, Subject, bs='fs', m=1),
data=simdat)

# extract with wrong select value:
newd <- inspect_random(m2, select=4)
# results in warning, automatically takes select=5
head(newd)
inspect_random(m2, select=5, cond=list(Subject=c('a01','a02','a03')))

# Alternatively, fix random effect of Condition, and plot
# random effects for subjects with lattice:
newd <- inspect_random(m2, select=5,
    cond=list(Subject=unique(simdat[simdat$Condition==0,'Subject'])),
    plot=FALSE)

# Make lattice plot:
require(lattice)
lattice::xyplot(fit~Time | Subject,
    data=newd, type="l",
    xlab="Time", ylab="Partial effect")

# Using argument 'fun':
inspect_random(m2, select=5, fun=mean,
    cond=list(Subject=unique(simdat[simdat$Condition==0,'Subject'])))
inspect_random(m2, select=5, fun=mean,
    cond=list(Subject=unique(simdat[simdat$Condition==2,'Subject'])),
    col='red', add=TRUE)
}

# see the vignette for examples:
vignette("overview", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_coefs}};
  \code{\link{get_difference}};
  \code{\link{get_modelterm}};
  \code{\link{get_predictions}}; \code{\link{get_random}};
  \code{\link{plotsurface}}
}

