context("Rcpp generate JSFS statistic")

test_that("calcJsfs works", {
    seg.sites <- list(matrix(c(1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1), 4, 3))
    attr(seg.sites[[1]], 'positions') = c(0.1, 0.5, 0.7)
    jsfs <- calcJsfs(seg.sites, c(2, 2))
    expect_true(is.matrix(jsfs))
    expect_equal(dim(jsfs), c(3, 3))
    expect_equal(sum(jsfs), 3)
    expect_equal(jsfs[2, 1], 1)
    expect_equal(jsfs[3, 2], 1)
    expect_equal(jsfs[2, 2], 1)
    
    seg.sites <- list(matrix(c(1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0), 4, 3))
    attr(seg.sites[[1]], 'positions') = c(0.1, 0.5, 0.7)
    jsfs <- calcJsfs(seg.sites, c(2, 2))
    expect_true(is.matrix(jsfs))
    expect_equal(dim(jsfs), c(3, 3))
    expect_equal(sum(jsfs), 3)
    expect_equal(jsfs[3, 3], 1)
    expect_equal(jsfs[1, 3], 1)
    expect_equal(jsfs[3, 1], 1)
    
    seg.sites[[2]] <- matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),  4, 3)
    attr(seg.sites[[2]], 'positions') = c(0.1, 0.5, 0.7)
    jsfs <- calcJsfs(seg.sites, c(2, 2))
    expect_true(is.matrix(jsfs))
    expect_equal(dim(jsfs), c(3, 3))
    expect_equal(sum(jsfs), 6)
    expect_equal(jsfs[3, 3], 4)
    expect_equal(jsfs[1, 3], 1)
    expect_equal(jsfs[3, 1], 1)
    
    seg.sites[[3]] <- matrix(numeric(), 4, 0)
    attr(seg.sites[[3]], 'positions') = c(0.1, 0.5, 0.7)
    jsfs <- calcJsfs(seg.sites, c(2, 2))
    expect_true(is.matrix(jsfs))
    expect_equal(dim(jsfs), c(3, 3))
    expect_equal(sum(jsfs), 6)
    expect_equal(jsfs[3, 3], 4)
    expect_equal(jsfs[1, 3], 1)
    expect_equal(jsfs[3, 1], 1)
})

test_that("calcJsfs works with trios", {
  seg_sites <- list(matrix(c(1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0), 4, 3))
  attr(seg_sites[[1]], 'positions') = c(0.1, 0.5, 0.7)

  calcJsfs(seg_sites, c(2,2))
})
