% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LittlewoodRichardson.R
\name{LRskew}
\alias{LRskew}
\title{Littlewood-Richardson rule for skew Schur polynomial}
\usage{
LRskew(lambda, mu, output = "dataframe")
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{output}{the type of the output, \code{"dataframe"} or \code{"list"}}
}
\value{
This computes the expression of the skew Schur polynomial
  associated to the skew partition defined by \code{lambda} and \code{mu}
  as a linear combination of Schur polynomials. If \code{output="dataframe"},
  the output is a dataframe with two columns: the column \code{coeff} gives
  the coefficients of this linear combination, and the column \code{nu}
  gives the partitions defining the Schur polynomials of this linear
  combination as character strings, e.g. the partition \code{c(4, 3, 1)} is
  given by \code{"4, 3, 1"}. If \code{output="list"}, the output is a list
  with two fields: the field \code{coeff} is the vector made of the
  coefficients of the linear combination, and the field \code{nu} is the
  list of partitions defining the Schur polynomials of the linear combination
  given as integer vectors.
}
\description{
Expression of a skew Schur polynomial as a linear
  combination of Schur polynomials.
}
\examples{
library(jack)
LRskew(lambda = c(4, 2, 1), mu = c(3, 1))
}
