% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_functions.R
\name{vars_gtrees}
\alias{vars_gtrees}
\title{Create necessary information to create variants using gene trees}
\usage{
vars_gtrees(obj = NULL, fn = NULL)
}
\arguments{
\item{obj}{Object containing gene trees.
This can be one of the following:
(1) A single \code{list} with a \code{trees} field inside. This field must
contain a set of gene trees for each sequence.
(2) A list of lists, each sub-list containing a \code{trees} field of
length 1. The top-level list must be of the same length as the
number of sequences.
Defaults to \code{NULL}.}

\item{fn}{A single string specifying the name of the file containing
the \code{ms}-style coalescent output with gene trees.
Defaults to \code{NULL}.}
}
\value{
A \code{vars_gtrees_info} object containing information used in \code{create_variants}
to create haploid variants.
This class is just a wrapper around a list of NEWICK tree strings, one for
each gene tree.
}
\description{
This function organizes higher-level information for creating variants from
gene trees output from coalescent simulations.
}
\details{
Using the \code{obj} argument is designed after the \code{trees} fields in the output from
the \code{scrm} and \code{coala} packages.
(These packages are not required to be installed when installing \code{jackalope}.)
To get gene trees, make sure to add \code{+ sumstat_trees()}
to the \code{coalmodel} for \code{coala}, or
make sure that \code{"-T"} is present in \code{args} for \code{scrm}.

If using an output file from a command-line program like \code{ms}/\code{msms},
add the \code{-T} option.
}
