% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfacorpcor.R
\name{lfa.corpcor}
\alias{lfa.corpcor}
\title{Logistic Factor Analysis without C++ Dependency}
\usage{
lfa.corpcor(x, d, ltrace = FALSE)
}
\arguments{
\item{x}{a matrix with \code{m} loci (rows) and \code{n} observations (columns).}

\item{d}{a number of logistic factors.}

\item{ltrace}{a logical indicator as to whether to print the progress.}
}
\value{
\code{lfa.corpcor} returns a \code{n*d} matrix of \code{d} logistic factors.
The last column is always an intercept term.
}
\description{
Estimate populatoin structure in genome-wide genotype matrices.
}
\details{
It performs the logistic factor analysis, similar to \code{lfa} function in the lfa package.
This function works without C++ dependencies.
However, it would be much slower, does not include any other LFA-related functions, checks, and warnings.
This function remains here for backward compatability - please use the \code{lfa} package.
}
\seealso{
\link{jackstraw_lfa}
}
