% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_jags_rep_draws.R
\name{tar_jags_rep_draws}
\alias{tar_jags_rep_draws}
\title{Tidy posterior draws from multiple MCMCs per model}
\usage{
tar_jags_rep_draws(
  name,
  jags_files,
  parameters.to.save,
  data = list(),
  batches = 1L,
  reps = 1L,
  transform = NULL,
  combine = FALSE,
  n.cluster = 1,
  n.chains = 3,
  n.iter = 2000,
  n.burnin = as.integer(n.iter/2),
  n.thin = 1,
  jags.module = c("glm", "dic"),
  inits = NULL,
  RNGname = c("Wichmann-Hill", "Marsaglia-Multicarry", "Super-Duper", "Mersenne-Twister"),
  jags.seed = NULL,
  stdout = NULL,
  stderr = NULL,
  progress.bar = "text",
  refresh = 0,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = "qs",
  format_df = "fst_tbl",
  repository = targets::tar_option_get("repository"),
  error = targets::tar_option_get("error"),
  memory = "transient",
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue")
)
}
\arguments{
\item{name}{Symbol, base name for the collection of targets.
Serves as a prefix for target names.}

\item{jags_files}{Character vector of JAGS model files. If you
supply multiple files, each model will run on the one shared dataset
generated by the code in \code{data}. If you supply an unnamed vector,
\code{tools::file_path_sans_ext(basename(jags_files))} will be used
as target name suffixes. If \code{jags_files} is a named vector,
the suffixed will come from \code{names(jags_files)}.}

\item{parameters.to.save}{Model parameters to save, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{data}{Code to generate the \code{data} list for the JAGS model.
Optionally include a \code{.join_data} element to join parts of the data
to correspondingly named parameters in the summary output.
See the vignettes for details.}

\item{batches}{Number of batches. Each batch runs a model \code{reps} times.}

\item{reps}{Number of replications per batch. Ideally, each rep
should produce its own random dataset using the code
supplied to \code{data}.}

\item{transform}{Symbol or \code{NULL}, name of a function that accepts
arguments \code{data} and \code{draws} and returns a data frame. Here,
\code{data} is the JAGS data list supplied to the model, and \code{draws}
is a data frame with one column per model parameter and one row
per posterior sample. Any arguments other than \code{data} and \code{draws}
must have valid default values because \code{jagstargets} will not
populate them. See the simulation-based calibration discussion
thread at \url{https://github.com/ropensci/jagstargets/discussions/31}
for an example.}

\item{combine}{Logical, whether to create a target to
combine all the model results
into a single data frame downstream. Convenient, but
duplicates data.}

\item{n.cluster}{Number of parallel processes, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.chains}{Number of MCMC chains, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.iter}{Number if iterations (including warmup), passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.burnin}{Number of warmup iterations, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{n.thin}{Thinning interval, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{jags.module}{Character vector of JAGS modules to load, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{inits}{Initial values of model parameters, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{RNGname}{Choice of random number generator, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{jags.seed}{The \code{jags.seed} argument of the \verb{tar_jags_rep*()}
functions is deprecated. See the "Seeds" section for details.}

\item{stdout}{Character of length 1, file path to write the stdout stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stdout.
Does not apply to messages, warnings, or errors.}

\item{stderr}{Character of length 1, file path to write the stderr stream
of the model when it runs. Set to \code{NULL} to print to the console.
Set to \code{R.utils::nullfile()} to suppress stderr.
Does not apply to messages, warnings, or errors.}

\item{progress.bar}{Type of progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{refresh}{Frequency for refreshing the progress bar, passed to
\code{R2jags::jags()} or \code{R2jags::jags.parallel()}.
See the argument documentation of the
\code{R2jags::jags()} and \code{R2jags::jags.parallel()} help files for details.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target builds or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Character of length 1, storage format of the data frames
of posterior summaries and other data frames returned by targets.
We recommend efficient data frame formats
such as \code{"feather"} or \code{"aws_parquet"}. For more on storage formats,
see the help file of \code{targets::tar_target()}.}

\item{format_df}{Character of length 1, storage format of the data frame
targets such as posterior draws. We recommend efficient data frame formats
such as \code{"feather"} or \code{"aws_parquet"}. For more on storage formats,
see the help file of \code{targets::tar_target()}.}

\item{repository}{Character of length 1, remote repository for target
storage. Choices:
\itemize{
\item \code{"local"}: file system of the local machine.
\item \code{"aws"}: Amazon Web Services (AWS) S3 bucket. Can be configured
with a non-AWS S3 bucket using the \code{endpoint} argument of
\code{\link[targets:tar_resources_aws]{tar_resources_aws()}}, but versioning capabilities may be lost
in doing so.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item \code{"gcp"}: Google Cloud Platform storage bucket.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}

Note: if \code{repository} is not \code{"local"} and \code{format} is \code{"file"}
then the target should create a single output file.
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. The local file is deleted after
the target runs.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
this memory strategy applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"worker"}: the worker saves/uploads the value.
\item \code{"none"}: almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language. If you do use it,
then the return value of the target is totally ignored
when the target ends, but
each downstream target still attempts to load the data file
(except when \code{retrieval = "none"}).

If you select \code{storage = "none"}, then
the return value of the target's command is ignored,
and the data is not saved automatically.
As with dynamic files (\code{format = "file"}) it is the
responsibility of the user to write to
the data store from inside the target.

The distinguishing feature of \code{storage = "none"}
(as opposed to \code{format = "file"})
is that in the general case,
downstream targets will automatically try to load the data
from the data store as a dependency. As a corollary, \code{storage = "none"}
is completely unnecessary if \code{format} is \code{"file"}.
}}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}
}
\value{
\code{tar_jags_rep_draws()} returns list of target objects.
See the "Target objects" section for
background.
The target names use the \code{name} argument as a prefix, and the individual
elements of \code{jags_files} appear in the suffixes where applicable.
As an example, the specific target objects returned by
\code{tar_jags_rep_dic(name = x, jags_files = "y.jags")}
are as follows.
\itemize{
\item \code{x_file_y}: reproducibly track the JAGS model file. Returns
a character vector of length 1 with the path to the JAGS
model file.
\item \code{x_lines_y}: read the contents of the JAGS model file
for safe transport to parallel workers.
Returns a character vector of lines in the model file.
\item \code{x_data}: use dynamic branching to generate multiple JAGS
datasets from the R expression in the \code{data} argument.
Each dynamic branch returns a batch of JAGS data lists.
\item \code{x_y}: run JAGS on each dataset from \code{x_data}.
Each dynamic branch returns a tidy data frame of draws
for each batch of data.
\item \code{x}: combine all the batches from \code{x_y} into a non-dynamic target.
Suppressed if \code{combine} is \code{FALSE}.
Returns a long tidy data frame with all draws
from all the branches of \code{x_y}.
}
}
\description{
Run multiple MCMCs on simulated datasets
and return posterior samples and the effective number of parameters
for each run.
}
\details{
The MCMC targets use \code{R2jags::jags()} if \code{n.cluster} is \code{1} and
\code{R2jags::jags.parallel()} otherwise. Most arguments to \code{tar_jags()}
are forwarded to these functions.
}
\section{Seeds}{

Rep-specific random number generator seeds for the data and models
are automatically set based on the batch, rep,
parent target name, and \code{tar_option_get("seed")}. This ensures
the rep-specific seeds do not change when you change the batching
configuration (e.g. 40 batches of 10 reps each vs 20 batches of 20
reps each). Each data seed is in the \code{.seed} list element of the output,
and each JAGS seed is in the .seed column of each JAGS model output.
}

\section{Target objects}{

Most \code{stantargets} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (requireNamespace("R2jags", quietly = TRUE)) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
library(jagstargets)
# Do not use a temp file for a real project
# or else your targets will always rerun.
tmp <- tempfile(pattern = "", fileext = ".jags")
tar_jags_example_file(tmp)
list(
  tar_jags_rep_draws(
    your_model,
    jags_files = tmp,
    data = tar_jags_example_data(),
    parameters.to.save = "beta",
    batches = 2,
    reps = 2,
    stdout = R.utils::nullfile(),
    stderr = R.utils::nullfile()
  )
)
}, ask = FALSE)
targets::tar_make()
})
}
}
