% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_empties.R
\name{remove_empty}
\alias{remove_empty}
\title{Remove empty rows and/or columns from a data.frame or matrix.}
\usage{
remove_empty(dat, which = c("rows", "cols"), cutoff = 1, quiet = TRUE)
}
\arguments{
\item{dat}{the input data.frame or matrix.}

\item{which}{one of "rows", "cols", or \code{c("rows", "cols")}.  Where no
value of which is provided, defaults to removing both empty rows and empty
columns, declaring the behavior with a printed message.}

\item{cutoff}{What fraction (>0 to <=1) of rows or columns must be empty to
be removed?}

\item{quiet}{Should messages be suppressed (\code{TRUE}) or printed
(\code{FALSE}) indicating the summary of empty columns or rows removed?}
}
\value{
Returns the object without its missing rows or columns.
}
\description{
Removes all rows and/or columns from a data.frame or matrix that
  are composed entirely of \code{NA} values.
}
\examples{
# not run:
# dat \%>\% remove_empty("rows")
# addressing a common untidy-data scenario where we have a mixture of
# blank values in some (character) columns and NAs in others:
library(dplyr)
dd <- tibble(x=c(LETTERS[1:5],NA,rep("",2)),
             y=c(1:5,rep(NA,3)))
# remove_empty() drops row 5 (all NA) but not 6 and 7 (blanks + NAs)
dd \%>\% remove_empty("rows")
# solution: preprocess to convert whitespace/empty strings to NA,
# _then_ remove empty (all-NA) rows
dd \%>\% mutate(across(is.character,~na_if(trimws(.),""))) \%>\%
   remove_empty("rows")
}
\seealso{
\code{\link[=remove_constant]{remove_constant()}} for removing
  constant columns.

Other remove functions: 
\code{\link{remove_constant}()}
}
\concept{remove functions}
