## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(jarbes)

## -----------------------------------------------------------------------------
## Not run: 
library(jarbes)

#Example: ppvipd
data("ppvipd")
bm1 = bmeta(ppvipd)


## -----------------------------------------------------------------------------
summary(bm1)

## -----------------------------------------------------------------------------
plot(bm1, x.lim = c(-3, 1), y.lim = c(0, 3))

## -----------------------------------------------------------------------------

diagnostic(bm1, study.names = ppvipd$name, 
           post.p.value.cut = 0.1,
           lwd.forest = 1, shape.forest = 4)

## -----------------------------------------------------------------------------
data("stemcells")
stemcells$TE = stemcells$effect.size
stemcells$seTE = stemcells$se.effect

## -----------------------------------------------------------------------------
bm2 = bmeta(stemcells)

## -----------------------------------------------------------------------------
summary(bm2)

## -----------------------------------------------------------------------------
plot(bm2, x.lim = c(-1, 7), y.lim = c(0, 1))

## -----------------------------------------------------------------------------
diagnostic(bm2, study.names = stemcells$trial,
           post.p.value.cut = 0.05,
           lwd.forest = 0.5, shape.forest = 4)

