% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{ppvcap}
\alias{ppvcap}
\title{Efficacy of Pneumococcal Polysaccharide Vaccine in Preventing Community Acquired Pneumonia}
\format{
A matrix with 16 rows and 18 columns. Each row represents study results, the columns are:
   \describe{
    \item{Name_Year}{Name of the first author and year.}
    \item{Year}{Year of publication.}
    \item{yt}{Number of infections in the intervention group.}
    \item{nt}{Number of patients in the intervention group.}
    \item{yc}{Number of infections in the control group.}
    \item{nc}{Number of patients in the control group.}
    \item{TE}{Treatment Effect as Log Odds Ratio.}
    \item{seTE}{Standard Error of the TE.}
    \item{logitPc}{Observed baseline rate in logit scale.}
    \item{N}{Total sample size.}
    \item{Study_Design}{Description of the study design.}
    \item{Intervention}{Type of vaccine used for itervention.}
    \item{Valency}{0 = PPV23; 1 = PPV-Other.}
    \item{low_income}{Indicates low income patients population with 0 = no; 1 = yes.}
    \item{R1}{Random sequence generation (selection bias: low;high;unclear.}
    \item{R2}{Allocation concealment (selection bias): low;high;unclear.}
    \item{R3}{Confounding: low;high;unclear.}
    \item{R4}{Blinding of participants and personnel (performace bias): low;high;unclear.}
    \item{R5}{Blinding of outcome assessment (detection bias): low;high;unclear.}
    \item{R6}{Incomplete outcome data (attrition bias): low;high;unclear.}
    \item{R7}{Selective reporting (reporting bias): low;high;unclear.}
    \item{Participants}{Comments on patients characteristics.}
    }
}
\source{
The data were obtainded from: Moberley et al. (2013).
}
\description{
PPV23 (23-valent pneumococcal polysaccharide vaccine) with 16 Randomized Clinical Trials
(RCTs); outcome variable CAP (community-acquired pneumonia).

This data frame corresponds to 16 randomized control trials (RCTs) reporting efficacy of
the PPV (Pneumococcal Polysaccharide) vaccine in preventing CAP (community acquired pneumonia).
The data frame contains the evaluation of Risk of Bias (RoB) of the trials and some study population
characteristics.
}
\references{
Moberley, S., Holden, J., Tatham, D., and Andrews, R. (2013), Vaccines for preventing pneumococcal infection in adults., Cochrane Database of Systematic Reviews, Issue 1. Art. No.: CD000422. DOI:10.1002/14651858.CD000422.pub3.

Verde, P.E. and Curcio, D. (2017) Hierarchical Meta-Regression Modelling: The Case of The Pneumococcal Polysaccharide Vaccine. Technical Report.
}
\keyword{datasets}
