% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_freqmap_wtypes.R
\name{plot_freqmap_wtypes}
\alias{plot_freqmap_wtypes}
\title{plot_freqmap_wtypes}
\usage{
plot_freqmap_wtypes(mat, loni, lati, all.types = TRUE, mytype = NULL,
  center = TRUE)
}
\arguments{
\item{mat}{Matrix output from extended_jc [loni,lati,time]}

\item{loni}{Vector with longitude values must be -180, 180}

\item{lati}{Latitude values}

\item{all.types}{Logical. If TRUE all weather types are plotted in the same plot}

\item{mytype}{Character with the name of the weather type wanted (i.g. N,NE,E,SE,S,SW,W,A,C and U)}

\item{center}{Logical. If TRUE a center map is plotted}
}
\value{
A ggplot2 map
}
\description{
Visualises absolute frequencies of the 11 main types from
             the extended_jc over the period.
}
\examples{
\dontrun{
library(jcext)
# This is a long running example for plotting results for all types globally
cwtGlobal <- extended_jc(press$msl, press$loni,press$lati, press$dates, gale=FALSE, num_cores=2)
wtypesGlobal <- cwtGlobal$wtypes
plot_freqmap_wtypes(wtypesGlobal,press$loni, press$lati, all.types = TRUE,mytype = NULL ,center = T)
# Plot the global results only for one type
plot_freqmap_wtypes(wtypesGlobal,press$loni, press$lati, all.types = FALSE,mytype = "C" ,center = T)
}

}
\seealso{
\code{\link{extended_jc}}
}
