// Generated by rstantools.  Do not edit by hand.

/*
    jfa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    jfa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with jfa.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_poisson_zero_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 66> locations_array__ =
  {" (found before start of program)",
  " (in 'poisson_zero', line 52, column 2 to column 94)",
  " (in 'poisson_zero', line 53, column 2 to column 38)",
  " (in 'poisson_zero', line 56, column 2 to column 28)",
  " (in 'poisson_zero', line 87, column 2 to column 51)",
  " (in 'poisson_zero', line 75, column 4 to column 33)",
  " (in 'poisson_zero', line 74, column 32 to line 76, column 3)",
  " (in 'poisson_zero', line 74, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 73, column 4 to column 32)",
  " (in 'poisson_zero', line 72, column 26 to line 74, column 3)",
  " (in 'poisson_zero', line 72, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 71, column 4 to column 37)",
  " (in 'poisson_zero', line 70, column 22 to line 72, column 3)",
  " (in 'poisson_zero', line 70, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 69, column 4 to column 34)",
  " (in 'poisson_zero', line 68, column 27 to line 70, column 3)",
  " (in 'poisson_zero', line 68, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 67, column 4 to column 34)",
  " (in 'poisson_zero', line 66, column 27 to line 68, column 3)",
  " (in 'poisson_zero', line 66, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 65, column 4 to column 33)",
  " (in 'poisson_zero', line 64, column 26 to line 66, column 3)",
  " (in 'poisson_zero', line 64, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 63, column 4 to column 35)",
  " (in 'poisson_zero', line 62, column 28 to line 64, column 3)",
  " (in 'poisson_zero', line 62, column 9 to line 76, column 3)",
  " (in 'poisson_zero', line 61, column 4 to column 32)",
  " (in 'poisson_zero', line 60, column 18 to line 62, column 3)",
  " (in 'poisson_zero', line 60, column 2 to line 76, column 3)",
  " (in 'poisson_zero', line 77, column 2 to column 29)",
  " (in 'poisson_zero', line 80, column 3 to column 117)",
  " (in 'poisson_zero', line 81, column 3 to column 52)",
  " (in 'poisson_zero', line 82, column 3 to column 46)",
  " (in 'poisson_zero', line 79, column 22 to line 83, column 3)",
  " (in 'poisson_zero', line 79, column 2 to line 83, column 3)",
  " (in 'poisson_zero', line 25, column 2 to column 17)",
  " (in 'poisson_zero', line 26, column 17 to column 18)",
  " (in 'poisson_zero', line 26, column 2 to column 20)",
  " (in 'poisson_zero', line 27, column 2 to column 17)",
  " (in 'poisson_zero', line 28, column 2 to column 18)",
  " (in 'poisson_zero', line 29, column 2 to column 22)",
  " (in 'poisson_zero', line 30, column 2 to column 21)",
  " (in 'poisson_zero', line 31, column 2 to column 17)",
  " (in 'poisson_zero', line 32, column 2 to column 20)",
  " (in 'poisson_zero', line 33, column 2 to column 18)",
  " (in 'poisson_zero', line 34, column 2 to column 19)",
  " (in 'poisson_zero', line 35, column 2 to column 19)",
  " (in 'poisson_zero', line 36, column 2 to column 14)",
  " (in 'poisson_zero', line 37, column 2 to column 18)",
  " (in 'poisson_zero', line 38, column 2 to column 24)",
  " (in 'poisson_zero', line 39, column 2 to column 21)",
  " (in 'poisson_zero', line 42, column 2 to column 39)",
  " (in 'poisson_zero', line 43, column 27 to column 37)",
  " (in 'poisson_zero', line 43, column 2 to column 39)",
  " (in 'poisson_zero', line 44, column 2 to column 20)",
  " (in 'poisson_zero', line 46, column 19 to column 28)",
  " (in 'poisson_zero', line 46, column 4 to column 28)",
  " (in 'poisson_zero', line 47, column 4 to column 19)",
  " (in 'poisson_zero', line 48, column 4 to column 32)",
  " (in 'poisson_zero', line 45, column 17 to line 49, column 3)",
  " (in 'poisson_zero', line 45, column 2 to line 49, column 3)",
  " (in 'poisson_zero', line 18, column 4 to column 16)",
  " (in 'poisson_zero', line 20, column 6 to column 25)",
  " (in 'poisson_zero', line 19, column 4 to line 20, column 25)",
  " (in 'poisson_zero', line 21, column 4 to column 15)",
  " (in 'poisson_zero', line 17, column 25 to line 22, column 3)"};
int num_zeros(const std::vector<int>& y, std::ostream* pstream__);
int num_zeros(const std::vector<int>& y, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int sum = std::numeric_limits<int>::min();
    current_statement__ = 61;
    sum = 0;
    current_statement__ = 63;
    for (int i = 1; i <= stan::math::size(y); ++i) {
      current_statement__ = 62;
      sum = (sum +
        stan::math::logical_eq(
          stan::model::rvalue(y, "y", stan::model::index_uni(i)), 0));
    }
    current_statement__ = 64;
    return sum;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_poisson_zero final : public model_base_crtp<model_poisson_zero> {
private:
  int n;
  std::vector<int> y;
  int N;
  double B;
  double alpha;
  double beta;
  int beta_prior;
  int uniform_prior;
  int gamma_prior;
  int normal_prior;
  int cauchy_prior;
  int t_prior;
  int chisq_prior;
  int exponential_prior;
  int use_likelihood;
  int N_zero;
  std::vector<int> y_nonzero;
  int N_nonzero;
public:
  ~model_poisson_zero() {}
  model_poisson_zero(stan::io::var_context& context__, unsigned int
                     random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_poisson_zero_namespace::model_poisson_zero";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 35;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 35;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 36;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      y = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 37;
      y = context__.vals_i("y");
      current_statement__ = 37;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 38;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 38;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "B", "double",
        std::vector<size_t>{});
      B = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 39;
      B = context__.vals_r("B")[(1 - 1)];
      current_statement__ = 39;
      stan::math::check_greater_or_equal(function__, "B", B, 0);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "alpha", "double",
        std::vector<size_t>{});
      alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "alpha", alpha, 0);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "beta", "double",
        std::vector<size_t>{});
      beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      beta = context__.vals_r("beta")[(1 - 1)];
      current_statement__ = 41;
      stan::math::check_greater_or_equal(function__, "beta", beta, 0);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "beta_prior", "int",
        std::vector<size_t>{});
      beta_prior = std::numeric_limits<int>::min();
      current_statement__ = 42;
      beta_prior = context__.vals_i("beta_prior")[(1 - 1)];
      current_statement__ = 43;
      context__.validate_dims("data initialization", "uniform_prior", "int",
        std::vector<size_t>{});
      uniform_prior = std::numeric_limits<int>::min();
      current_statement__ = 43;
      uniform_prior = context__.vals_i("uniform_prior")[(1 - 1)];
      current_statement__ = 44;
      context__.validate_dims("data initialization", "gamma_prior", "int",
        std::vector<size_t>{});
      gamma_prior = std::numeric_limits<int>::min();
      current_statement__ = 44;
      gamma_prior = context__.vals_i("gamma_prior")[(1 - 1)];
      current_statement__ = 45;
      context__.validate_dims("data initialization", "normal_prior", "int",
        std::vector<size_t>{});
      normal_prior = std::numeric_limits<int>::min();
      current_statement__ = 45;
      normal_prior = context__.vals_i("normal_prior")[(1 - 1)];
      current_statement__ = 46;
      context__.validate_dims("data initialization", "cauchy_prior", "int",
        std::vector<size_t>{});
      cauchy_prior = std::numeric_limits<int>::min();
      current_statement__ = 46;
      cauchy_prior = context__.vals_i("cauchy_prior")[(1 - 1)];
      current_statement__ = 47;
      context__.validate_dims("data initialization", "t_prior", "int",
        std::vector<size_t>{});
      t_prior = std::numeric_limits<int>::min();
      current_statement__ = 47;
      t_prior = context__.vals_i("t_prior")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization", "chisq_prior", "int",
        std::vector<size_t>{});
      chisq_prior = std::numeric_limits<int>::min();
      current_statement__ = 48;
      chisq_prior = context__.vals_i("chisq_prior")[(1 - 1)];
      current_statement__ = 49;
      context__.validate_dims("data initialization", "exponential_prior",
        "int", std::vector<size_t>{});
      exponential_prior = std::numeric_limits<int>::min();
      current_statement__ = 49;
      exponential_prior = context__.vals_i("exponential_prior")[(1 - 1)];
      current_statement__ = 50;
      context__.validate_dims("data initialization", "use_likelihood", "int",
        std::vector<size_t>{});
      use_likelihood = std::numeric_limits<int>::min();
      current_statement__ = 50;
      use_likelihood = context__.vals_i("use_likelihood")[(1 - 1)];
      current_statement__ = 51;
      N_zero = std::numeric_limits<int>::min();
      current_statement__ = 51;
      N_zero = num_zeros(y, pstream__);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("y_nonzero", "n - N_zero", (n -
        N_zero));
      current_statement__ = 53;
      y_nonzero = std::vector<int>((n - N_zero),
                    std::numeric_limits<int>::min());
      current_statement__ = 54;
      N_nonzero = std::numeric_limits<int>::min();
      current_statement__ = 54;
      N_nonzero = 0;
      current_statement__ = 60;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 56;
        if (stan::math::logical_eq(
              stan::model::rvalue(y, "y", stan::model::index_uni(i)), 0)) {
          continue;
        }
        current_statement__ = 57;
        N_nonzero = (N_nonzero + 1);
        current_statement__ = 58;
        stan::model::assign(y_nonzero,
          stan::model::rvalue(y, "y", stan::model::index_uni(i)),
          "assigning variable y_nonzero", stan::model::index_uni(N_nonzero));
      }
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "N_zero", N_zero, 0);
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "y_nonzero", y_nonzero,
        0);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_poisson_zero";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_poisson_zero_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ p_error = DUMMY_VAR__;
      current_statement__ = 1;
      p_error = in__.template read_constrain_lub<local_scalar_t__,
                  jacobian__>(stan::model::rvalue(
                                (Eigen::Matrix<double,1,-1>(1) <<
                                                                 (uniform_prior ? alpha : 0)).finished(),
                                "FnMakeRowVec__((uniform_prior ? alpha : promote(0, real)))",
                                stan::model::index_uni(1)),
                  stan::model::rvalue(
                    (Eigen::Matrix<double,1,-1>(1) <<
                                                     (uniform_prior ? beta : 1)).finished(),
                    "FnMakeRowVec__((uniform_prior ? beta : promote(1, real)))",
                    stan::model::index_uni(1)), lp__);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>(0, (B / N), lp__);
      local_scalar_t__ p_zero = DUMMY_VAR__;
      current_statement__ = 3;
      p_zero = (1 - p_error);
      {
        current_statement__ = 28;
        if (beta_prior) {
          current_statement__ = 26;
          lp_accum__.add(stan::math::beta_lpdf<propto__>(p_error, alpha, beta));
        } else {
          current_statement__ = 25;
          if (uniform_prior) {
            current_statement__ = 23;
            lp_accum__.add(stan::math::uniform_lpdf<propto__>(p_error, alpha,
                             beta));
          } else {
            current_statement__ = 22;
            if (gamma_prior) {
              current_statement__ = 20;
              lp_accum__.add(stan::math::gamma_lpdf<propto__>(p_error, alpha,
                               beta));
            } else {
              current_statement__ = 19;
              if (normal_prior) {
                current_statement__ = 17;
                lp_accum__.add(stan::math::normal_lpdf<propto__>(p_error,
                                 alpha, beta));
              } else {
                current_statement__ = 16;
                if (cauchy_prior) {
                  current_statement__ = 14;
                  lp_accum__.add(stan::math::cauchy_lpdf<propto__>(p_error,
                                   alpha, beta));
                } else {
                  current_statement__ = 13;
                  if (t_prior) {
                    current_statement__ = 11;
                    lp_accum__.add(stan::math::student_t_lpdf<propto__>(
                                     p_error, alpha, 0, 1));
                  } else {
                    current_statement__ = 10;
                    if (chisq_prior) {
                      current_statement__ = 8;
                      lp_accum__.add(stan::math::chi_square_lpdf<propto__>(
                                       p_error, alpha));
                    } else {
                      current_statement__ = 7;
                      if (exponential_prior) {
                        current_statement__ = 5;
                        lp_accum__.add(stan::math::exponential_lpdf<
                                         propto__>(p_error, alpha));
                      }
                    }
                  }
                }
              }
            }
          }
        }
        current_statement__ = 29;
        lp_accum__.add(stan::math::uniform_lpdf<propto__>(lambda, 0, (B / N)));
        current_statement__ = 34;
        if (use_likelihood) {
          current_statement__ = 30;
          lp_accum__.add((N_zero *
            stan::math::log_sum_exp(
              stan::math::bernoulli_lpmf<false>(1, p_zero),
              (stan::math::bernoulli_lpmf<false>(0, p_zero) +
              stan::math::poisson_lpmf<false>(0, lambda)))));
          current_statement__ = 31;
          lp_accum__.add((N_nonzero *
            stan::math::bernoulli_lpmf<false>(0, p_zero)));
          current_statement__ = 32;
          lp_accum__.add(stan::math::poisson_lpmf<false>(y_nonzero, lambda));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_poisson_zero_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double p_error = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      p_error = in__.template read_constrain_lub<local_scalar_t__,
                  jacobian__>(stan::model::rvalue(
                                (Eigen::Matrix<double,1,-1>(1) <<
                                                                 (uniform_prior ? alpha : 0)).finished(),
                                "FnMakeRowVec__((uniform_prior ? alpha : promote(0, real)))",
                                stan::model::index_uni(1)),
                  stan::model::rvalue(
                    (Eigen::Matrix<double,1,-1>(1) <<
                                                     (uniform_prior ? beta : 1)).finished(),
                    "FnMakeRowVec__((uniform_prior ? beta : promote(1, real)))",
                    stan::model::index_uni(1)), lp__);
      double lambda = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      lambda = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>(0, (B / N), lp__);
      double p_zero = std::numeric_limits<double>::quiet_NaN();
      out__.write(p_error);
      out__.write(lambda);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 3;
      p_zero = (1 - p_error);
      if (emit_transformed_parameters__) {
        out__.write(p_zero);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      double theta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      theta = (((p_error * lambda) * N) / B);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "theta", theta, 0);
      out__.write(theta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ p_error = DUMMY_VAR__;
      current_statement__ = 1;
      p_error = in__.read<local_scalar_t__>();
      out__.write_free_lub(stan::model::rvalue(
                             (Eigen::Matrix<double,1,-1>(1) <<
                                                              (uniform_prior ? alpha : 0)).finished(),
                             "FnMakeRowVec__((uniform_prior ? alpha : promote(0, real)))",
                             stan::model::index_uni(1)),
        stan::model::rvalue(
          (Eigen::Matrix<double,1,-1>(1) << (uniform_prior ? beta : 1)).finished(),
          "FnMakeRowVec__((uniform_prior ? beta : promote(1, real)))",
          stan::model::index_uni(1)), p_error);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, (B / N), lambda);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "p_error",
        "double", std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "lambda", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ p_error = DUMMY_VAR__;
      current_statement__ = 1;
      p_error = context__.vals_r("p_error")[(1 - 1)];
      out__.write_free_lub(stan::model::rvalue(
                             (Eigen::Matrix<double,1,-1>(1) <<
                                                              (uniform_prior ? alpha : 0)).finished(),
                             "FnMakeRowVec__((uniform_prior ? alpha : promote(0, real)))",
                             stan::model::index_uni(1)),
        stan::model::rvalue(
          (Eigen::Matrix<double,1,-1>(1) << (uniform_prior ? beta : 1)).finished(),
          "FnMakeRowVec__((uniform_prior ? beta : promote(1, real)))",
          stan::model::index_uni(1)), p_error);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = context__.vals_r("lambda")[(1 - 1)];
      out__.write_free_lub(0, (B / N), lambda);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"p_error", "lambda"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"p_zero"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"theta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>> temp{std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>> temp{std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "p_error");
    param_names__.emplace_back(std::string() + "lambda");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "p_zero");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "theta");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "p_error");
    param_names__.emplace_back(std::string() + "lambda");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "p_zero");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "theta");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"p_error\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p_zero\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"p_error\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p_zero\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (1);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (1);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_poisson_zero_namespace::model_poisson_zero;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_poisson_zero_namespace::profiles__;
}
#endif
#endif
