% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jl_-utils.R
\name{jl-helpers-utils}
\alias{jl-helpers-utils}
\alias{is_jl}
\alias{jl_put}
\alias{jl_get}
\alias{jl}
\alias{jl_dict}
\title{Helpers for converting model specifications in R to Julia equivalents}
\usage{
is_jl(x, type)

jl_put(x)

jl_get(x)

jl(expr, ..., .R = FALSE, .passthrough = FALSE)

jl_dict(...)
}
\arguments{
\item{x}{An object}

\item{type}{Type of Julia object to additional test for}

\item{expr}{A string of Julia code}

\item{...}{Interpolated elements. In the case of \code{jl()}:.
\itemize{
\item If all named, elements are introduced as Julia variables in the \code{expr}
\item If all unnamed, elements are interpolated into \code{expr} via \code{\link[=sprintf]{sprintf()}}
}}

\item{.R}{Whether to simplify and return as R object, if possible.}

\item{.passthrough}{Whether to return \code{expr} as-is if it's already a Julia
object. Mostly for internal use.}
}
\value{
A Julia object of type \verb{<JuliaProxy>}
}
\description{
Helpers for converting model specifications in R to Julia equivalents
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# (general) Use `jl()` to evaluate arbitrary Julia expressions from string
jl("1 .+ [1,3]")

# `jl()` takes elements in `...` that you can reference in the expression
jl("1 .+ a", a = c(1L, 3L)) # Named arguments are introduced as variables
jl("1 .+ \%s", "[1,2]") # Unnamed arguments are interpolated via `sprintf()`

# Use `is_jl()` to test if object is a Julia (`<JuliaProxy>`) object
is_jl(jl("1"))

# Use `jl_put()` and `jl_get()` to transfer data between R and Julia
jl_put(1L)
identical(jl_get(jl_put(1L)), 1L)

# `jl_dict()` opinionatedly constructs a Dictionary data type
## Basic `list()`-like usage
jl_dict(age = 20:25, sex = c("M", "F"))
## Splats when a single list is supplied
jl_dict(list(a = 1, b = 2))
## Wrap scalars in `I()` to prevent vector conversion
jl_dict(a = 1:2, b = 3:4, c = I(5))

stop_julia()
}
\dontshow{\}) # examplesIf}
}
\keyword{internal}
