% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotblsm.R
\name{Plotblsm}
\alias{Plotblsm}
\title{Two dimensional plot of the Bipartite Latent Space Model}
\usage{
Plotblsm(
  Y.ia,
  model,
  labels = NULL,
  xlab = "",
  ylab = "",
  plotedges = TRUE,
  edgecolor = "black",
  colEll.i = rgb(0.6, 0.6, 0.6, alpha = 0.1),
  colEll.ia = rgb(1, 0.6, 0.6, alpha = 0.1),
  LEVEL = 0.8,
  pchplot = 20,
  pchEll = 19,
  pchPl = 19,
  cexPl = 1.1,
  arrowhead = FALSE,
  curve = 0,
  xlim = c(-2, 2),
  ylim = c(-2, 2),
  lwdLine = 0.001,
  ...
)
}
\arguments{
\item{Y.ia}{N by M matrix containing the binary multivariate attributes}

\item{model}{model output from BLSM}

\item{labels}{vector of characters containing the item names}

\item{xlab}{name of the x axis}

\item{ylab}{name of the y axis}

\item{plotedges}{TRUE or FALSE, whether the bipartite edges should be plotted}

\item{edgecolor}{color of the edge. Default \code{edgecolor = "black"}}

\item{colEll.i}{\code{col} for the ellipses of persons. Default \code{rgb(.6, .6 ,.6 , alpha=.1)}}

\item{colEll.ia}{\code{col} for the ellipses of attributes Default \code{rgb(1, .6 ,.6 , alpha=.1)}}

\item{LEVEL}{levels of confidence bounds shown when plotting the ellipses. Default \code{LEVEL = .95}}

\item{pchplot}{Default \code{pchplot = 20}}

\item{pchEll}{\code{pch} for the ellipses. Default \code{pchEll = 19}}

\item{pchPl}{\code{pch} for the points representing the nodes. Default \code{pchPl = 19}}

\item{cexPl}{\code{cex} for the points representing the nodes. Default \code{cexPl = 1.1}}

\item{arrowhead}{logical, if the arrowed are to be plotted. Default \code{arrowhead = FALSE}}

\item{curve}{curvature of edges. Default \code{curve = 0}}

\item{xlim}{range for x}

\item{ylim}{range for y}

\item{lwdLine}{lwd of edges. Default \code{lwdLine = .3}}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\value{
plot
}
\description{
plot the latent space with two types of nodes and one type of relations
}
\examples{
attach(french)
a=blsm(Niter=3,Y.ia,D=2)
Plotblsm(Y.ia,  a)
}
