% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmcm.R
\name{jmcm}
\alias{jmcm}
\title{Fit Joint Mean-Covariance Models}
\usage{
jmcm(formula, data = NULL, triple = c(3, 3, 3), cov.method = c("mcd",
  "acd", "hpc"), optim.method = c("default", "BFGS"),
  control = jmcmControl(), start = NULL)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the covariates
for both the mean and covariance matrix part of the model, with the response,
the corresponding subject id and measurement time on the left of a operator~,
divided by vertical bars ("|").}

\item{data}{a data frame containing the variables named in formula.}

\item{triple}{an integer vector of length three containing the degrees of the
three polynomial functions for the mean structure, the log innovation
-variances and the autoregressive or moving average coefficients when 'mcd'
or 'acd' is specified for cov.method. It refers to the degree for the mean
structure, variances and angles when 'hpc' is specified for cov.method.}

\item{cov.method}{covariance structure modelling method,
choose 'mcd' (Pourahmadi 1999), 'acd' (Chen and Dunson 2013) or 'hpc'
(Zhang et al. 2015).}

\item{optim.method}{optimization method, choose 'default' or 'BFGS' (vmmin in R)}

\item{control}{a list (of correct class, resulting from jmcmControl())
containing control parameters, see the *jmcmControl documentation for
details.}

\item{start}{starting values for the parameters in the model.}
}
\description{
Fit a joint mean-covariance model to longitudinal data, via
maximum likelihood.
}
\examples{
cattleA <- cattle[cattle$group=='A', ]
fit.mcd <- jmcm(weight | id | I(ceiling(day/14 + 1)) ~ 1 | 1,
data=cattleA, triple = c(8, 4, 3), cov.method = 'mcd', 
control = jmcmControl(trace = TRUE, ignore.const.term = FALSE, 
original.poly.order = TRUE))
}
\references{
Pan J, Pan Y (2017). "jmcm: An R Package for Joint Mean-Covariance Modeling of Longitudinal Data." \emph{Journal of Statistical Software}, 82(9), 1--29.
}
