
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
anovaRMNPOptions <- R6::R6Class(
    "anovaRMNPOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            measures = NULL,
            pairs = FALSE,
            desc = FALSE,
            plots = FALSE,
            plotType = "means", ...) {

            super$initialize(
                package='jmv',
                name='anovaRMNP',
                requiresData=TRUE,
                ...)
        
            private$..measures <- jmvcore::OptionVariables$new(
                "measures",
                measures,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..pairs <- jmvcore::OptionBool$new(
                "pairs",
                pairs,
                default=FALSE)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..plotType <- jmvcore::OptionList$new(
                "plotType",
                plotType,
                options=list(
                    "means",
                    "medians"),
                default="means")
        
            self$.addOption(private$..measures)
            self$.addOption(private$..pairs)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..plotType)
        }),
    active = list(
        measures = function() private$..measures$value,
        pairs = function() private$..pairs$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        plotType = function() private$..plotType$value),
    private = list(
        ..measures = NA,
        ..pairs = NA,
        ..desc = NA,
        ..plots = NA,
        ..plotType = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
anovaRMNPResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$..table,
        comp = function() private$..comp,
        plot = function() private$..plot),
    private = list(
        ..table = NA,
        ..comp = NA,
        ..plot = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Repeated Measures ANOVA (Non-parametric)")
            private$..table <- jmvcore::Table$new(
                options=options,
                name="table",
                title="Friedman",
                rows=1,
                clearWith=list(
                    "measures"),
                columns=list(
                    list(`name`="stat", `title`="\u03C7\u00B2", `type`="number"),
                    list(`name`="df", `title`="df", `type`="integer"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
            private$..comp <- jmvcore::Table$new(
                options=options,
                name="comp",
                title="Pairwise Comparisons (Durbin-Conover)",
                visible="(pairs)",
                clearWith=list(
                    "measures"),
                columns=list(
                    list(`name`="i1", `title`="", `type`="text"),
                    list(`name`="sep", `title`="", `content`="-", `type`="text", `format`="narrow"),
                    list(`name`="i2", `title`="", `type`="text"),
                    list(`name`="stat", `title`="Statistic", `type`="number"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
            private$..plot <- jmvcore::Image$new(
                options=options,
                name="plot",
                title="Descriptive Plot",
                visible="(plots)",
                renderFun=".plot",
                clearWith=list(
                    "plotType",
                    "measures"))
            self$add(private$..table)
            self$add(private$..comp)
            self$add(private$..plot)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
anovaRMNPBase <- R6::R6Class(
    "anovaRMNPBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anovaRMNP',
                version = c(1,0,0),
                options = options,
                results = anovaRMNPResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Repeated Measures ANOVA (Non-parametric)
#'
#' Friedman
#'
#' @examples
#' \dontrun{
#' data('bugs', package = 'jmv')
#' 
#' anovaRMNP(bugs, measures = c('LDLF', 'LDHF', 'HDLF', 'HDHF'))
#' 
#' #
#' #  Friedman
#' #  ------------------------
#' #    X²      df    p
#' #  ------------------------
#' #    55.8     3    < .001
#' #  ------------------------
#' #
#' }
#' @param data the data as a data frame
#' @param measures a vector of strings naming the repeated measures variables
#' @param pairs \code{TRUE} or \code{FALSE} (default), perform pairwise 
#'   comparisons 
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide a descriptive 
#'   plot 
#' @param plotType \code{'means'} (default) or \code{'medians'}, the error 
#'   bars to use in the plot 
#' @export
anovaRMNP <- function(
    data,
    measures,
    pairs = FALSE,
    desc = FALSE,
    plots = FALSE,
    plotType = "means") {

    options <- anovaRMNPOptions$new(
        measures = measures,
        pairs = pairs,
        desc = desc,
        plots = plots,
        plotType = plotType)

    results <- anovaRMNPResults$new(
        options = options)

    analysis <- anovaRMNPClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
