test_that("arrange_cols_omv works", {
    nmeInp <- paste0(tempfile(), ".rds")
    nmeOut <- paste0(tempfile(), "_A.omv")
    saveRDS(jmvReadWrite::AlbumSales, nmeInp)

    arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("selSbj", "Sales", "Adverts", "Airplay", "Image"))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(200, 5))
    expect_equal(names(df4Chk), c("selSbj", "Sales", "Adverts", "Airplay", "Image"))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("integer", "integer", "double", "integer", "integer"))
    unlink(nmeOut)

    arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(Sales = -3, Adverts = 2))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(200, 5))
    expect_equal(names(df4Chk), c("selSbj", "Sales", "Airplay", "Image", "Adverts"))
    expect_equal(as.vector(sapply(df4Chk, typeof)), c("integer", "integer", "integer", "integer", "double"))
    unlink(nmeOut)

    # test cases for code coverage ============================================================================================================================
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = list()))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c()))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c(1, 2)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("", "")))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = c()))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list()))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(1, 1)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(A = "1", B = "1")))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(A = 1, B = 1.1)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(A = 1, B = 0)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("Sale", "Adverts", "Airplay", "Image")))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(Sale = -3)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(Sales = -5)))
    expect_false(file.exists(nmeOut))
    expect_error(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varMve = list(Sales = -3, Image = 2)))
    expect_false(file.exists(nmeOut))

    expect_warning(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("Sales", "Adverts", "Airplay", "Image")))
    expect_true(file.exists(nmeOut))
    unlink(nmeOut)
    expect_warning(arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("selSbj", "Sales", "Adverts", "Airplay", "Image"), varMve = list(Sales = -3)))
    expect_true(file.exists(nmeOut))
    unlink(nmeOut)
    unlink(nmeInp)

    # test cases for the transfer of analyses =================================================================================================================
    nmeInp <- file.path("..", "ToothGrowth.omv")
    arrange_cols_omv(dtaInp = nmeInp, fleOut = nmeOut, varOrd = c("Filter 1", "ID", "len", "logLen", "supp", "supp - Transform 1", "dose", "dose2", "Trial", "Residuals", "J", "K", "L"), psvAnl = TRUE)
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE, getSyn = TRUE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(60, 13))
    expect_equal(names(df4Chk), c("Filter 1", "ID", "len", "logLen", "supp", "supp - Transform 1", "dose", "dose2", "Trial", "Residuals", "J", "K", "L"))
    expect_equal(as.vector(sapply(df4Chk, typeof)),
      c("logical", "character", "double", "double", "integer", "integer", "double", "integer", "integer", "double", "double", "double", "integer"))
    expect_equal(zip::zip_list(nmeOut)$filename,
      c("data.bin", "strings.bin", "meta", "metadata.json", "xdata.json", "index.html", "01 empty/analysis", "02 anova/analysis", "03 empty/analysis",
        "04 ancova/analysis", "05 empty/analysis", "02 anova/resources/3b518ea3d44f095f.png", "02 anova/resources/07288f96c58ae68b.png"))
    expect_equal(attr(df4Chk, "syntax"),
      list(paste("jmv::ANOVA(formula = len ~ supp + dose2 + supp:dose2, data = data, effectSize = \"partEta\", modelTest = TRUE, qq = TRUE,",
                 "contrasts = list(list(var=\"supp\", type=\"none\"), list(var=\"dose2\", type=\"polynomial\")), postHoc = ~ supp + dose2, emMeans = ~ dose2:supp)"),
           "jmv::ancova(formula = len ~ supp + dose, data = data, effectSize = \"partEta\", modelTest = TRUE)"))
    expect_warning(arrange_cols_omv(dtaInp = jmvReadWrite::AlbumSales, fleOut = nmeOut, varOrd = c("selSbj", "Sales", "Adverts", "Airplay", "Image"), psvAnl = TRUE))
    unlink(nmeOut)
    # do not unlink nmeInp, this isn't a generated file, but a link
})
