% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.jointmeta1.R
\name{ranef.jointmeta1}
\alias{ranef.jointmeta1}
\title{Function to extract estimated random effects}
\usage{
\method{ranef}{jointmeta1}(object, type = c("individual", "study"), ...)
}
\arguments{
\item{object}{a \code{jointmeta1} object (the result of fitting a model using
\code{\link{jointmeta1}}, see \code{\link{jointmeta1.object}})}

\item{type}{the type of random effects to return.  Set \code{type =
'individual'} to return the estimates of the individual level random
effects.  Set \code{type = 'study'} to return the estimates of the level
random effects if included in the model.}

\item{...}{additional arguments; currently none are used.}
}
\value{
If \code{type = 'individual'} then a list of matrices containing the
  individual level random effects is returned.  This list is of length equal
  to the number of studies in the dataset.  Each matrix has number of rows
  equal to the number of individuals in the corresponding study, and number
  of columns equal to the number of individual level random effects.

  If \code{type = 'study'} then if study level random effects are present in
  the supplied model fit, a matrix of the estimated study level random
  effects is returned, with number of rows equal to the number of studies in
  the dataset, and number of columns equal to the number of study level
  random effects.  If study level random effects are requested but are not
  present in the supplied model fit, an error message is returned.
}
\description{
This function extracts the estimated values of the random effects from a
supplied \code{jointmeta1} fit.
}
\examples{
   #change example data to jointdata object
   jointdat2<-tojointdata(longitudinal = simdat2$longitudinal,
   survival = simdat2$survival, id = 'id',longoutcome = 'Y',
   timevarying = c('time','ltime'),
   survtime = 'survtime', cens = 'cens',time = 'time')

   #set variables to factors
   jointdat2$baseline$study <- as.factor(jointdat2$baseline$study)
   jointdat2$baseline$treat <- as.factor(jointdat2$baseline$treat)

   #fit multi-study joint model
   #note: for demonstration purposes only - max.it restricted to 5
   #model would need more iterations to truely converge
   onestagefit<-jointmeta1(data = jointdat2, long.formula = Y ~ 1 + time +
                           + treat + study, long.rand.ind = c('int', 'time'),
                           long.rand.stud = c('treat'),
                           sharingstrct = 'randprop',
                           surv.formula = Surv(survtime, cens) ~ treat,
                           study.name = 'study', strat = TRUE, max.it=5)

    #extract the individual level random effects covariance matrix
    ranef(onestagefit, type = 'individual')

    #extract the study level random effects covariance matrix
    ranef(onestagefit, type = 'study')
}
\seealso{
\code{\link{jointmeta1}}, \code{\link{jointmeta1.object}},
  \code{\link{fixef}}
}
