% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{joinet}
\alias{joinet}
\title{Multivariate Elastic Net Regression}
\usage{
joinet(
  Y,
  X,
  family = "gaussian",
  nfolds = 10,
  foldid = NULL,
  type.measure = "deviance",
  alpha.base = 1,
  alpha.meta = 1,
  ...
)
}
\arguments{
\item{Y}{outputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{q} columns (variables),
with positive correlation (see details)}

\item{X}{inputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{family}{distribution\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"gaussian"}, \code{"binomial"} or \code{"poisson"}}

\item{nfolds}{number of folds}

\item{foldid}{fold identifiers\strong{:}
vector of length \eqn{n} with entries between \eqn{1} and \code{nfolds};
or \code{NULL} (balance)}

\item{type.measure}{loss function\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"deviance"}, \code{"class"}, \code{"mse"} or \code{"mae"}
(see \code{\link[glmnet]{cv.glmnet}})}

\item{alpha.base}{elastic net mixing parameter for base learners\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{alpha.meta}{elastic net mixing parameter for meta learner\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{...}{further arguments passed to \code{\link[glmnet]{glmnet}}}
}
\value{
This function returns an object of class \code{joinet}.
Available methods include
\code{\link[=predict.joinet]{predict}},
\code{\link[=coef.joinet]{coef}},
and \code{\link[=weights.joinet]{weights}}.
The slots \code{base} and \code{meta} each contain
\eqn{q} \code{\link[glmnet]{cv.glmnet}}-like objects.
}
\description{
Implements multivariate elastic net regression.
}
\details{
\strong{correlation:}
The \eqn{q} outcomes should be positively correlated.
Avoid negative correlations by changing the sign of the variable.

\strong{elastic net:}
\code{alpha.base} controls input-output effects,
\code{alpha.meta} controls output-output effects;
lasso renders sparse models (\code{alpha}\eqn{=1}),
ridge renders dense models (\code{alpha}\eqn{=0})
}
\examples{
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)

\dontrun{
browseVignettes("joinet") # further examples}

}
\references{
Armin Rauschenberger, Enrico Glaab (2020)
"Predicting correlated outcomes from molecular data"
\emph{Manuscript in preparation}.
}
\seealso{
\code{\link{cv.joinet}}, vignette
}
