% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jwt.R
\name{jwt_encode_hmac}
\alias{jwt_encode_hmac}
\alias{jwt}
\alias{jose}
\alias{jwt_decode_hmac}
\alias{jwt_encode_sig}
\alias{jwt_decode_sig}
\title{JSON Web Token}
\usage{
jwt_encode_hmac(claim = jwt_claim(), secret, size = 256, header = NULL)

jwt_decode_hmac(jwt, secret)

jwt_encode_sig(claim = jwt_claim(), key, size = 256, header = NULL)

jwt_decode_sig(jwt, pubkey)
}
\arguments{
\item{claim}{a named list with fields to include in the jwt payload}

\item{secret}{string or raw vector with a secret passphrase}

\item{size}{bitsize of sha2 signature, i.e. \code{sha256}, \code{sha384} or \code{sha512}.
Only for HMAC/RSA, not applicable for ECDSA keys.}

\item{header}{named list with additional parameter fields to include in the jwt header as
defined in \href{https://tools.ietf.org/html/rfc7515#section-9.1.2}{rfc7515 section 9.1.2}}

\item{jwt}{string containing the JSON Web Token (JWT)}

\item{key}{path or object with RSA or EC private key, see \link[openssl:read_key]{openssl::read_key}.}

\item{pubkey}{path or object with RSA or EC public key, see \link[openssl:read_pubkey]{openssl::read_pubkey}.}
}
\description{
Sign or verify a JSON web token. The \code{jwt_encode_hmac}, \code{jwt_encode_rsa},
and \code{jwt_encode_ec} default to \code{HS256}, \code{RS256}, and \code{ES256}
respectively. See \href{https://jwt.io}{jwt.io} or
\href{https://tools.ietf.org/html/rfc7519}{RFC7519} for more details.
}
\examples{
# HMAC signing
mysecret <- "This is super secret"
token <- jwt_claim(name = "jeroen", session = 123456)
sig <- jwt_encode_hmac(token, mysecret)
jwt_decode_hmac(sig, mysecret)

# RSA encoding
mykey <- openssl::rsa_keygen()
pubkey <- as.list(mykey)$pubkey
sig <- jwt_encode_sig(token, mykey)
jwt_decode_sig(sig, pubkey)

# Same with EC
mykey <- openssl::ec_keygen()
pubkey <- as.list(mykey)$pubkey
sig <- jwt_encode_sig(token, mykey)
jwt_decode_sig(sig, pubkey)
}
