% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_url_confirmed.R
\name{jpinfect_url_confirmed}
\alias{jpinfect_url_confirmed}
\title{Display dataset URLs of Confirmed Cases based on Infectious Diseases Weekly Report (IDWR)}
\usage{
jpinfect_url_confirmed(year = 2001, type = "sex")
}
\arguments{
\item{year}{The year for which to generate the URL. Defaults to 2001.}

\item{type}{The type of data to download. Must be either "sex" or "place". Defaults to "sex".}
}
\value{
A character string containing the URL for the specified year's data.
}
\description{
This function displays the URL for downloading Confirmed Cases based on
Infectious Diseases Weekly Report (IDWR) from the Japan Institute for Health Security (JIHS)
for a specified year.
See this webpage for further details: https://id-info.jihs.go.jp/
}
\examples{
\donttest{
# Check URL for weekly cases by sex and prefecture in 2010
jpinfect_url_confirmed(2010)

# Check URL for weekly cases by suspected place of infection and prefecture in 2010
jpinfect_url_confirmed(2010, type = "place")
}
}
