% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GenBS.R
\name{GenBS}
\alias{GenBS}
\title{Generalized Black Scholes model for pricing vanilla European options}
\usage{
GenBS(s, X, r, Sigma, t, div_yield = 0)
}
\arguments{
\item{s}{the spot price of the asset (the stock price for options on stocks)}

\item{X}{the exercise or strike price of the option}

\item{r}{the continuously compounded rate of interest in decimal (0.10 or 10e-2 for 10\%)
(use \code{\link{equiv.rate}} to convert to a continuously compounded rate)}

\item{Sigma}{the volatility of the asset price in decimal  (0.20 or 20e-2 for 20\%)}

\item{t}{the maturity of the option in years}

\item{div_yield}{the continuously compounded dividend yield (0.05 or 5e-2 for 5\%)
(use \code{\link{equiv.rate}} to convert to a continuously compounded rate)}
}
\value{
A list of the following elements
\item{call}{the value of a call option}
\item{put}{the value of a put option}
\item{Greeks}{a list of the following elements}
\item{Greeks$callDelta}{the delta of a call option - the sensitivity to the spot price of the asset}
\item{Greeks$putDelta}{the delta of a put option - the sensitivity to the spot price of the asset}
\item{Greeks$callTheta}{the theta of a call option - the time decay of the option value
with passage of time. Note that time is measured in years. To find a daily theta divided by 365.}
\item{Greeks$putTheta}{the theta of a put option}
\item{Greeks$Gamma}{the gamma of a call or put option - the second derivative with respect to the spot price
or the sensitivity of delta to the spot price}
\item{Greeks$Vega}{the vega of a call or put option - the sensitivity to the volatility}
\item{Greeks$callRho}{the rho of a call option - the sensitivity to the interest rate}
\item{Greeks$putRho}{the rho of a put option - the sensitivity to the interest rate}
\item{extra}{a list of the following elements}
\item{extra$d1}{the d1 of the Generalized Black Schole formula}
\item{extra$d2}{the d2 of the Generalized Black Schole formula}
\item{extra$Nd1}{is \link{pnorm}(d1)}
\item{extra$Nd2}{is \link{pnorm}(d2)}
\item{extra$Nminusd1}{is \link{pnorm}(-d1)}
\item{extra$Nminusd2}{is \link{pnorm}(-d2)}
\item{extra$callProb}{the (risk neutral) probability that the call will be exercised = Nd2}
\item{extra$putProb}{the (risk neutral) probability that the put will be exercised = Nminusd2}
}
\description{
Compute values of call and put options as well as the Greeks -
the sensitivities of the option price to various input arguments using the
Generalized Black Scholes model. "Generalized" means that the asset can
have a continuous dividend yield.
}
\details{
The Generalized Black Scholes formula for call options is \cr
\eqn{e^{-r t} (s \;  e^{g t} \; Nd1 - X \; Nd2)}{exp(-r * t) * (s * exp(g * t) * Nd1 - X * Nd2)} \cr
where \cr
\eqn{g = r - div\_yield} \cr
\eqn{Nd1 = N(d1)} and \eqn{Nd2 = N(d2)} \cr
\eqn{d1 = \frac{log(s / X) + (g + Sigma^2/ 2)  t}{Sigma \sqrt{t}}}{d1 = (log(s / X) + (g + Sigma^2/ 2) * t) / (Sigma * sqrt(t))} \cr
\eqn{d2 = d1 - Sigma \sqrt{t}}{d2 = d1 - Sigma * sqrt(t)} \cr
N denotes the normal CDF (\link{pnorm})\cr
For put options, the formula is \cr
\eqn{e^{-r t}  (-s \; e^{g  t} \; Nminusd1 + X \;  Nminusd2)}{exp(-r * t) * (-s * exp(g * t) * Nminusd1 + X * Nminusd2)}\cr
where \cr
\eqn{Nminusd1 = N(-d1)} and \eqn{Nminusd2 = N(-d2)} \cr
}

