% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bonds.R
\name{coupons}
\alias{coupons}
\alias{coupons.dates}
\alias{coupons.n}
\alias{coupons.next}
\alias{coupons.prev}
\title{Bond pricing using yield to maturity.}
\usage{
coupons.dates(settle, mature, freq = 2)

coupons.n(settle, mature, freq = 2)

coupons.next(settle, mature, freq = 2)

coupons.prev(settle, mature, freq = 2)
}
\arguments{
\item{settle}{The settlement date for which the bond is traded. Can be a
character string or any object that can be converted into date using
\code{\link{as.Date}}.}

\item{mature}{The maturity date of the bond. Can be a character string or
any object that can be converted into date using \code{\link{as.Date}}}

\item{freq}{The frequency of coupon payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}
}
\description{
Convenience functions for finding coupon dates and number of coupons of a bond.
}
\author{
Prof. Jayanth R. Varma \email{jrvarma@iimahd.ernet.in}
}

