% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daycount.R
\name{daycount}
\alias{daycount}
\alias{daycount.30.360}
\alias{daycount.actual}
\alias{yearFraction}
\title{Day count and year fraction for bond pricing}
\usage{
yearFraction(
  d1,
  d2,
  r1,
  r2,
  freq = 2,
  convention = c("30/360", "ACT/ACT", "ACT/360", "30/360E")
)

daycount.actual(d1, d2, variant = c("bond"))

daycount.30.360(d1, d2, variant = c("US", "EU", "IT"))
}
\arguments{
\item{d1}{The starting date of period for day counts}

\item{d2}{The ending date of period for day counts}

\item{r1}{The starting date of reference period for ACT/ACT day counts}

\item{r2}{The ending date of reference period for ACT/ACT day counts}

\item{freq}{The frequency of coupon payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}

\item{convention}{The daycount convention}

\item{variant}{Three variants of the 30/360 convention are implemented, but
only one variant of ACT/ACT is currently implemented}
}
\description{
Implements 30/360, ACT/360, ACT/360 and 30/360E day count conventions.
}
\references{
The 30/360 day count was converted from C++ code in the
QuantLib library
}
\author{
Prof. Jayanth R. Varma \email{jrvarma@iima.ac.in}
}
