% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{logisticModule2}
\alias{logisticModule2}
\title{logisticModule2: Shiny modulde server for logistic regression for reactive data.}
\usage{
logisticModule2(input, output, session, data, data_label,
  data_varStruct = NULL, nfactor.limit = 10, design.survey = NULL,
  default.unires = T, limit.unires = 20)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{reactive data}

\item{data_label}{reactive data label}

\item{data_varStruct}{List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{reactive survey data. default: NULL}

\item{default.unires}{Set default independent variables using univariate analysis, Default: T}

\item{limit.unires}{Change to default.unires = F if number of independent variables > limit.unires, Default: 20}
}
\value{
Shiny modulde server for logistic regression.
}
\description{
Shiny modulde server for logistic regression for reactive data.
}
\details{
Shiny modulde server for logistic regression.
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     regressModuleUI("logistic")
   ),
   mainPanel(
     DTOutput("logistictable")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_logistic <- callModule(logisticModule2, "logistic", data = data, data_label = data.label,
                           data_varStruct = NULL)

  output$logistictable <- renderDT({
    datatable(out_logistic()$table, rownames=T, caption = out_logistic()$caption)
  })
}
}
