% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/books.R
\name{jst_get_chapters}
\alias{jst_get_chapters}
\title{Extract information on book chapters}
\usage{
jst_get_chapters(file_path, authors = FALSE)
}
\arguments{
\item{file_path}{The path to a \code{.xml}-file for a book or research report.}

\item{authors}{Extracting the authors is an expensive operation which makes
the function ~3 times slower, depending on the number of chapters and
the number of authors. Defaults to \code{FALSE}. Use \code{authors = TRUE} to
import the authors too.}
}
\value{
A \code{tibble} containing the extracted meta-data with the following
columns:
\itemize{
\item book_id \emph{(chr)}: The book id of type "jstor", which is not a registered
DOI.
\item file_name \emph{(chr)}: The filename of the original .xml-file. Can be used
for joining with other data for the same file.
\item part_id \emph{(chr)}: The id of the part.
\item part_label \emph{(chr)}: A label for the part, if specified.
\item part_title \emph{(chr)}: The title of the part.
\item part_subtitle \emph{(chr)}: The subtitle of the part, if specified.
\item authors \emph{(list)}: A list-column with information on the authors. Can be
unnested with \code{\link[tidyr:unnest]{tidyr::unnest()}}. See the examples and \code{\link[=find_authors]{find_authors()}}.
\item abstract \emph{(chr)}: The abstract to the part.
\item part_first_page \emph{(chr)}: The page where the part begins.
}
}
\description{
\code{jst_get_chapters()} extracts meta-data from JSTOR-XML files for book
chapters.
}
\details{
Currently, \code{jst_get_chapters()} is quite a lot slower than most of the other
functions. It is roughly 10 times slower than \code{jst_get_book}, depending on
the number of chapters to extract.
}
\examples{
# extract parts without authors
jst_get_chapters(jst_example("sample_book.xml"))

# import authors too
parts <- jst_get_chapters(jst_example("sample_book.xml"), authors = TRUE)
parts

tidyr::unnest(parts)
}
