% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnotes.R
\name{jst_get_footnotes}
\alias{jst_get_footnotes}
\title{Extract all footnotes}
\usage{
jst_get_footnotes(file_path)
}
\arguments{
\item{file_path}{The path to the \code{.xml}-file from which footnotes should be
extracted.}
}
\value{
A \code{tibble} containing the content from \code{fn-group} (usually the
footnotes). If there were no footnotes, \code{NA_character} is returned for the
column \code{footnotes}.
}
\description{
This function extracts the content of \code{fn-group} from journal-articles.
}
\details{
The \code{fn-group} usually contains footnotes corresponding to the article.
However, since footnotes are currently not fully supported by DfR,
there is no comprehensive documentation on the different variants. \code{jstor}
therefore extracts the content of \code{fn-group} exactly as it appears in the
data. Because of this, there might be other content present than footnotes.

In order to get all available information on citation data, you might need to
combine \code{jst_get_footnotes()} with \code{jst_get_references()}.
}
\examples{
jst_get_footnotes(jst_example("sample_with_footnotes.xml"))
}
