% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_summ.R
\name{plot_summs}
\alias{plot_summs}
\alias{plot_coefs}
\title{Plot Regression Summaries}
\usage{
plot_summs(..., ci_level = 0.95, model.names = NULL, coefs = NULL,
  omit.coefs = "(Intercept)", color.class = "Set2")

plot_coefs(..., ci_level = 0.95, model.names = NULL, coefs = NULL,
  omit.coefs = "(Intercept)", color.class = "Set2")
}
\arguments{
\item{...}{regression model(s).}

\item{ci_level}{The desired width of confidence intervals for the
coefficients. Default: 0.95}

\item{model.names}{If plotting multiple models simultaneously, you can
provide a vector of names here. If NULL, they will be named sequentially
as "Model 1", "Model 2", and so on. Default: NULL}

\item{coefs}{If you'd like to include only certain coefficients, provide
them as a vector. If it is a named vector, then the names will be used
in place of the variable names. See details for examples. Default: NULL}

\item{omit.coefs}{If you'd like to specify some coefficients to not include
in the plot, provide them as a vector. This argument is overridden by
\code{coefs} if both are provided. By default, the intercept term is omitted.
To include the intercept term, just set omit.coefs to NULL.}

\item{color.class}{A color class understood by
\code{\link[ggplot2:scale_colour_brewer]{ggplot2::scale_colour_brewer()}} for differentiating multiple models.
Not used if only one model is plotted. Default: 'Set2'}
}
\value{
A ggplot object.
}
\description{
\code{plot_summs} and \code{plot_coefs} create regression coefficient
plots with ggplot2.
}
\details{
A note on the distinction between \code{plot_summs} and \code{plot_coefs}:
\code{plot_summs} only accepts models supported by \code{\link[=summ]{summ()}} and allows users
to take advantage of the standardization and robust standard error features
(among others as may be relevant). \code{plot_coefs} supports any models that
have a \code{\link[broom:tidy]{broom::tidy()}} method defined in the broom package, but of course
lacks any additional features like robust standard errors. To get a mix
of the two, you can pass \code{summ} objects to \code{plot_coefs} too.

For \code{coefs}, if you provide a named vector of coefficients, then
the plot will refer to the selected coefficients by the names of the
vector rather than the coefficient names. For instance, if I want to
include only the coefficients for the \code{hp} and \code{mpg} but have
the plot refer to them as "Horsepower" and "Miles/gallon", I'd provide
the argument like this:
\code{c("Horsepower" = "hp", "Miles/gallon" = "mpg")}
}
\examples{
states <- as.data.frame(state.x77)
fit1 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))
fit2 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))
fit3 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))

# Plot all 3 regressions with custom predictor labels,
# standardized coefficients, and robust standard errors
plot_summs(fit1, fit2, fit3,
           coefs = c("Frost Days" = "Frost", "\% Illiterate" = "Illiteracy",
                     "Murder Rate" = "Murder"),
           scale = TRUE, robust = TRUE)

}
