% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svytools.R
\name{svycor}
\alias{svycor}
\title{Calculate Pearson correlations with complex survey data}
\usage{
svycor(formula, design, na.rm = FALSE, digits = getOption("jtools-digits",
  default = 2), sig.stats = FALSE, bootn = 1000, mean1 = TRUE, ...)
}
\arguments{
\item{formula}{A formula (e.g., ~var1+var2) specifying the terms to correlate.}

\item{design}{The \code{survey.design} or \code{svyrep.design} object.}

\item{na.rm}{Logical. Should cases with missing values be dropped?}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired number.}

\item{sig.stats}{Logical. Perform non-parametric bootstrapping
(using \code{\link[weights]{wtd.cor}}) to generate standard errors and
associated t- and p-values. See details for some considerations when doing
null hypothesis testing with complex survey correlations.}

\item{bootn}{If \code{sig.stats} is TRUE, this defines the number of bootstraps
to be run to generate the standard errors and p-values. For large values and
large datasets, this can contribute considerably to processing time.}

\item{mean1}{If \code{sig.stats} is TRUE, it is important to know whether the
sampling weights should have a mean of 1. That is, should the standard errors
be calculated as if the number of rows in your dataset is the total number of
observations (TRUE) or as if the sum of the weights in your dataset is the
total number of observations (FALSE)?}

\item{...}{Additional arguments passed to \code{\link[survey]{svyvar}}.}
}
\value{
If significance tests are not requested, there is one returned value:

\item{cors}{The correlation matrix (without rounding)}

If significance tests are requested, the following are also returned:

\item{p.values}{A matrix of p values}
\item{t.values}{A matrix of t values}
\item{std.err}{A matrix of standard errors}
}
\description{
\code{svycor} extends the \code{survey} package by calculating correlations
with syntax similar to the original package, which for reasons unknown lacks
such a function.
}
\details{
This function extends the \code{survey} package by calculating the correlations
for user-specified variables in survey design and returning a correlation matrix.

Using the \code{\link[weights]{wtd.cor}} function, this function also returns
standard errors and p-values for the correlation terms using a sample-weighted
bootstrapping procedure. While correlations do not require distributional
assumptions, hypothesis testing (i.e., \eqn{r > 0}) does. The appropriate way to
calculate standard errors and use them to define a probability is not straightforward
in this scenario since the weighting causes heteroskedasticity, thereby violating
an assumption inherent in the commonly used methods for converting Pearson's
correlations into t-values. The method provided here is defensible, but if
reporting in scientific publications the method should be spelled out.
}
\note{
This function was designed in part on the procedure recommended by Thomas
Lumley, the author of the survey package, on
\href{http://stackoverflow.com/questions/34418822/pearson-correlation-coefficient-in-rs-survey-package#41031088}{Stack Overflow}. However, he has not reviewed or endorsed this implementation.
All defects are attributed to the author.
}
\examples{
 library(survey)
 data(api)
 # Create survey design object
 dstrat <- svydesign(id = ~1,strata = ~stype, weights = ~pw, data = apistrat,
                     fpc=~fpc)

 # Print correlation matrix
 svycor(~api00+api99+dnum, design = dstrat)

 # Save the results, extract correlation matrix
 out <- svycor(~api00+api99+dnum, design = dstrat)
 out$cors

}
\seealso{
\code{\link[weights]{wtd.cor}}, \code{\link[survey]{svyvar}}

Other \pkg{survey} package extensions: \code{\link{svysd}}

Other survey tools: \code{\link{pf_sv_test}},
  \code{\link{svysd}}, \code{\link{weights_tests}},
  \code{\link{wgttest}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
\concept{\pkg{survey} package extensions}
\concept{survey tools}
