% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_na_fields.r
\name{dropRowsWithNAField}
\alias{dropRowsWithNAField}
\title{drops rows with NA values in specified fields}
\usage{
dropRowsWithNAField(x, fld = names(x), verbose = FALSE)
}
\arguments{
\item{x}{data frame}

\item{fld}{vector with names of fields which must have no NA values}

\item{verbose}{single logical value, if \code{TRUE} then produce verbose
messages}
}
\value{
data frame without rows containing NA in the specified data fields.
  There may be NA values in the resulting data frame in fields which are not
  listed in fld.
}
\description{
employs \code{\link[stats]{complete.cases}} which is fast
  internal C code. Returns a data frame with unused factor levels dropped
  (these may have been introduced by dropping rows with some NA values)
}
