% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.r
\name{random_test_numbers}
\alias{random_test_numbers}
\alias{random_test_integers}
\alias{random_test_letters}
\title{create extreme random numbers}
\usage{
random_test_numbers(n = n_rnd, min = NULL, max = NULL, hole = NULL)

random_test_integers(n = n_rnd, min = -.Machine$integer.max,
  max = .Machine$integer.max, hole = NULL)

random_test_letters(n = n_rnd, max_str_len = 257)
}
\arguments{
\item{n}{integer number of each group to generate}

\item{min}{optional minimum number}

\item{max}{optional maximum number}

\item{hole}{is a closed range of numbers not to include, e.g. c(1,2) would
discard 1, 1.1 pi/2 and 2}

\item{max_str_len}{integer scalar, maximum length of possible strings
created, as distinct from number of strings given by \code{n}}
}
\value{
vector length 5n+1 containing variety of difficult numbers for
  testing purposes
}
\description{
create random Dates, POSIX dates, letters and numbers. The
  numbers explore limits of R precision and floating point and integer
  ranges. Zero, negatives, positives.
}
