% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{IncrementTest-class}
\alias{IncrementTest-class}
\alias{.IncrementTest}
\title{Frequency Increment Test}
\description{
An S4 class to represent a Frequency Increment Test results.
}
\section{Slots}{

\describe{
\item{\code{counts}}{An \eqn{m \times p}{m x p} \code{\link{numeric}} matrix of count data.}

\item{\code{dates}}{A length-\eqn{m} \code{\link{numeric}} vector of dates.}

\item{\code{statistic}}{A \code{\link{numeric}} vector giving the values of the t-statistic.}

\item{\code{parameter}}{An \code{\link{integer}} giving the degrees of freedom for the
t-statistic.}

\item{\code{p_value}}{A \code{\link{numeric}} vector giving the the p-value for the test.}
}}

\section{Coerce}{

In the code snippets below, \code{x} is an \code{IncrementTest} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{AoristicSum-class}},
\code{\link{CountApportion-class}},
\code{\link{EventDate-class}},
\code{\link{MeanDate-class}},
\code{\link{RateOfChange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
