% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mcd.R
\docType{methods}
\name{plot_mcd}
\alias{plot_mcd}
\alias{plot,MeanDate,missing-method}
\alias{plot,SimulationMeanDate,missing-method}
\title{MCD Plot}
\usage{
\S4method{plot}{MeanDate,missing}(
  x,
  calendar = getOption("kairos.calendar"),
  decreasing = TRUE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)

\S4method{plot}{SimulationMeanDate,missing}(
  x,
  calendar = getOption("kairos.calendar"),
  interval = "student",
  level = 0.8,
  decreasing = TRUE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{MeanDate}} object.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[=calendar]{calendar()}}).}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort be increasing or
decreasing?}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x,
y and z axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{interval}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{student}" (the default),
"\code{normal}", "\code{percentiles}" or "\code{range}" (min-max).
Any unambiguous substring can be given.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Only used if \code{interval} is not "\code{range}".}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
MCD Plot
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
(mc_dates <- mcd(zuni[100:125, ], dates = mid))

## Get MCD in years CE
time(mc_dates, calendar = CE())

## Plot
plot(mc_dates)

## Bootstrap resampling
boot <- bootstrap(mc_dates, n = 30)
head(boot)

## Jackknife resampling
jack <- jackknife(mc_dates)
head(jack)

## Simulation
sim <- simulate(mc_dates, nsim = 30)
plot(sim, interval = "range", pch = 16)
}
\seealso{
Other mean ceramic date tools: 
\code{\link{mcd}()},
\code{\link{resample_mcd}}
}
\author{
N. Frerebeau
}
\concept{mean ceramic date tools}
