% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fit}
\alias{fit}
\title{Train a Keras model}
\usage{
fit(object, x, y, batch_size = 32, epochs = 10, verbose = 1,
  callbacks = NULL, validation_split = 0, validation_data = NULL,
  shuffle = TRUE, class_weight = NULL, sample_weight = NULL,
  initial_epoch = 0, ...)
}
\arguments{
\item{object}{Model to train.}

\item{x}{Vector, matrix, or array of training data (or list if the model has
multiple inputs). If all inputs in the model are named, you can also pass a
list mapping input names to data.}

\item{y}{Vector, matrix, or array of target data (or list if the model has
multiple outputs). If all outputs in the model are named, you can also pass
a list mapping output names to data.}

\item{batch_size}{Number of samples per gradient update.}

\item{epochs}{Number of times to iterate over the training data arrays.}

\item{verbose}{Verbosity mode (0 = silent, 1 = verbose, 2 = one log line per
epoch).}

\item{callbacks}{List of callbacks to be called during training.}

\item{validation_split}{Float between 0 and 1: fraction of the training data
to be used as validation data. The model will set apart this fraction of
the training data, will not train on it, and will evaluate the loss and any
model metrics on this data at the end of each epoch.}

\item{validation_data}{Data on which to evaluate the loss and any model
metrics at the end of each epoch. The model will not be trained on this
data. This could be a list (x_val, y_val) or a list (x_val, y_val,
val_sample_weights).}

\item{shuffle}{\code{TRUE} to shuffle the training data before each epoch.}

\item{class_weight}{Optional named list mapping indices (integers) to a
weight (float) to apply to the model's loss for the samples from this class
during training. This can be useful to tell the model to "pay more
attention" to samples from an under-represented class.}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample. In the case of
temporal data, you can pass a 2D array with shape (samples,
sequence_length), to apply a different weight to every timestep of every
sample. In this case you should make sure to specify
sample_weight_mode="temporal" in \code{\link[=compile]{compile()}}.}

\item{initial_epoch}{epoch at which to start training (useful for resuming a
previous training run).}

\item{...}{Unused}
}
\description{
Trains the model for a fixed number of epochs (iterations on a dataset).
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate_generator}}, \code{\link{evaluate}},
  \code{\link{fit_generator}}, \code{\link{get_config}},
  \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
