% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_remote_monitor}
\alias{callback_remote_monitor}
\title{Callback used to stream events to a server.}
\usage{
callback_remote_monitor(
  root = "http://localhost:9000",
  path = "/publish/epoch/end/",
  field = "data",
  headers = NULL,
  send_as_json = FALSE
)
}
\arguments{
\item{root}{String; root url of the target server.}

\item{path}{String; path relative to \code{root} to which the events will be sent.}

\item{field}{String; JSON field under which the data will be stored.
The field is used only if the payload is sent within a form
(i.e. send_as_json is set to \code{FALSE}).}

\item{headers}{Named list; optional custom HTTP headers.}

\item{send_as_json}{Boolean; whether the request should be
sent as \code{"application/json"}.}
}
\value{
A \code{Callback} instance that can be passed to \code{\link[=fit.keras.src.models.model.Model]{fit.keras.src.models.model.Model()}}.
}
\description{
Requires the \code{requests} library.
Events are sent to \code{root + '/publish/epoch/end/'} by default. Calls are
HTTP POST, with a \code{data} argument which is a
JSON-encoded named list of event data.
If \code{send_as_json = TRUE}, the content type of the request will be
\code{"application/json"}.
Otherwise the serialized JSON will be sent within a form.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/callbacks/remote_monitor#remotemonitor-class}
}

Other callbacks: \cr
\code{\link{Callback}()} \cr
\code{\link{callback_backup_and_restore}()} \cr
\code{\link{callback_csv_logger}()} \cr
\code{\link{callback_early_stopping}()} \cr
\code{\link{callback_lambda}()} \cr
\code{\link{callback_learning_rate_scheduler}()} \cr
\code{\link{callback_model_checkpoint}()} \cr
\code{\link{callback_reduce_lr_on_plateau}()} \cr
\code{\link{callback_swap_ema_weights}()} \cr
\code{\link{callback_tensorboard}()} \cr
\code{\link{callback_terminate_on_nan}()} \cr
}
\concept{callbacks}
