% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint_unitnorm}
\alias{constraint_unitnorm}
\title{Constrains the weights incident to each hidden unit to have unit norm.}
\usage{
constraint_unitnorm(axis = 1L)
}
\arguments{
\item{axis}{integer, axis along which to calculate weight norms.
For instance, in a \code{Dense} layer the weight matrix
has shape \verb{(input_dim, output_dim)},
set \code{axis} to \code{0} to constrain each weight vector
of length \verb{(input_dim,)}.
In a \code{Conv2D} layer with \code{data_format = "channels_last"},
the weight tensor has shape
\verb{(rows, cols, input_depth, output_depth)},
set \code{axis} to \verb{[0, 1, 2]}
to constrain the weights of each filter tensor of size
\verb{(rows, cols, input_depth)}.}
}
\value{
A \code{Constraint} instance, a callable that can be passed to layer
constructors or used directly by calling it with tensors.
}
\description{
Constrains the weights incident to each hidden unit to have unit norm.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/constraints#unitnorm-class}
}

Other constraints: \cr
\code{\link{Constraint}()} \cr
\code{\link{constraint_maxnorm}()} \cr
\code{\link{constraint_minmaxnorm}()} \cr
\code{\link{constraint_nonneg}()} \cr
}
\concept{constraints}
