% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_stft}
\alias{initializer_stft}
\title{Initializer of Conv kernels for Short-term Fourier Transformation (STFT).}
\usage{
initializer_stft(
  side = "real",
  window = "hann",
  scaling = "density",
  periodic = FALSE
)
}
\arguments{
\item{side}{String, \code{"real"} or \code{"imag"} deciding if the kernel will compute
the real side or the imaginary side of the output. Defaults to
\code{"real"}.}

\item{window}{String for the name of the windowing function in the
\code{scipy.signal.windows} module, or array_like for the window values,
or \code{NULL} for no windowing.}

\item{scaling}{String, \code{"density"} or \code{"spectrum"} for scaling of the window
for normalization, either L2 or L1 normalization.
\code{NULL} for no scaling.}

\item{periodic}{Boolean, if True, the window function will be treated as
periodic. Defaults to \code{FALSE}.}
}
\value{
An \code{Initializer} instance that can be passed to layer or variable
constructors, or called directly with a \code{shape} to return a Tensor.
}
\description{
Since the formula involves complex numbers, this class compute either the
real or the imaginary components of the final output.

Additionally, this initializer supports windowing functions across the time
dimension as commonly used in STFT. Windowing functions from the Python module
\code{scipy.signal.windows} are supported, including the common \code{hann} and
\code{hamming} windowing functions. This layer supports periodic windows and
scaling-based normalization.

This is primarily intended for use in the \code{STFTSpectrogram} layer.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Standalone usage:
initializer <- initializer_stft("real", "hann", "density", FALSE)
values <- initializer(shape = c(128, 1, 513))
}\if{html}{\out{</div>}}
}

\seealso{
Other initializers: \cr
\code{\link{initializer_constant}()} \cr
\code{\link{initializer_glorot_normal}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_identity}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_ones}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_truncated_normal}()} \cr
\code{\link{initializer_variance_scaling}()} \cr
\code{\link{initializer_zeros}()} \cr

Other constant initializers: \cr
\code{\link{initializer_constant}()} \cr
\code{\link{initializer_identity}()} \cr
\code{\link{initializer_ones}()} \cr
\code{\link{initializer_zeros}()} \cr
}
\concept{constant initializers}
\concept{initializers}
