% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_iou}
\alias{metric_iou}
\title{Computes the Intersection-Over-Union metric for specific target classes.}
\usage{
metric_iou(
  ...,
  num_classes,
  target_class_ids,
  name = NULL,
  dtype = NULL,
  ignore_class = NULL,
  sparse_y_true = TRUE,
  sparse_y_pred = TRUE,
  axis = -1L
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{num_classes}{The possible number of labels the prediction task can have.}

\item{target_class_ids}{A list of target class ids for which the
metric is returned. To compute IoU for a specific class, a list
of a single id value should be provided.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}

\item{ignore_class}{Optional integer. The ID of a class to be ignored during
metric computation. This is useful, for example, in segmentation
problems featuring a "void" class (commonly -1 or 255) in
segmentation maps. By default (\code{ignore_class=NULL}), all classes are
considered.}

\item{sparse_y_true}{Whether labels are encoded using integers or
dense floating point vectors. If \code{FALSE}, the \code{argmax} function
is used to determine each sample's most likely associated label.}

\item{sparse_y_pred}{Whether predictions are encoded using integers or
dense floating point vectors. If \code{FALSE}, the \code{argmax} function
is used to determine each sample's most likely associated label.}

\item{axis}{(Optional) -1 is the dimension containing the logits.
Defaults to \code{-1}.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{iou <- true_positives / (true_positives + false_positives + false_negatives)
}\if{html}{\out{</div>}}

Intersection-Over-Union is a common evaluation metric for semantic image
segmentation.

To compute IoUs, the predictions are accumulated in a confusion matrix,
weighted by \code{sample_weight} and the metric is then calculated from it.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.

Note, this class first computes IoUs for all individual classes, then
returns the mean of IoUs for the classes that are specified by
\code{target_class_ids}. If \code{target_class_ids} has only one id value, the IoU of
that specific class is returned.
}
\section{Examples}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_iou(num_classes = 2L, target_class_ids = list(0L))
m$update_state(c(0, 0, 1, 1), c(0, 1, 0, 1))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(
## [[1 1]
##  [1 1]], shape=(2, 2), dtype=int64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.3333333, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$reset_state()
m$update_state(c(0, 0, 1, 1), c(0, 1, 0, 1),
               sample_weight = 10 * c(0.3, 0.3, 0.3, 0.1))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(
## [[3 3]
##  [3 1]], shape=(2, 2), dtype=int64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.3333333, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model \%>\% compile(
  optimizer = 'sgd',
  loss = 'mse',
  metrics = list(metric_iou(num_classes = 2L, target_class_ids = list(0L))))
}\if{html}{\out{</div>}}
}

\seealso{
Other iou metrics: \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{iou metrics}
\concept{metrics}
