% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{plot_confusion}
\alias{plot_confusion}
\title{plot_confusion}
\usage{
plot_confusion(..., display = TRUE, return_ggplot = FALSE, title = "",
  subtitle = "")
}
\arguments{
\item{...}{kms_fit objects. (For each, object$y_test must be binary or categorical.)}

\item{display}{Logical: display ggplot comparing confusion matrices? (Default TRUE.)}

\item{return_ggplot}{Default FALSE (if TRUE, returns the ggplot object for further customization, etc.).}

\item{title}{ggplot title}

\item{subtitle}{ggplot subtitle}
}
\value{
(optional) ggplot. set return_ggplot=TRUE
}
\description{
plot_confusion
}
\examples{

if(is_keras_available()){

   model_tanh <- kms(Species ~ ., iris, 
                     activation = "tanh", Nepochs=5, 
                     units=4, seed=1, verbose=0)
   model_softmax <- kms(Species ~ ., iris, 
                        activation = "softmax", Nepochs=5, 
                        units=4, seed=1, verbose=0)
   model_relu <- kms(Species ~ ., iris, 
                     activation = "relu", Nepochs=5, 
                     units=4, seed=1, verbose=0)
                     
   plot_confusion(model_tanh, model_softmax, model_relu, 
                  title="Species", 
                  subtitle="Activation Function Comparison")
   
}
}
