% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1d.smooths.r
\name{kernel.smooth.in.time}
\alias{kernel.smooth.in.time}
\title{Kernel smooth data in time alone}
\usage{
kernel.smooth.in.time(
  dataset,
  dependent.variable = "dependent.variable",
  time = "year",
  weight = "weight",
  bandwidth = 10,
  sample.density.threshold = 3,
  length.out = 1000,
  alpha = 0.05,
  xlabel = "year",
  ylabel,
  greyscale = "compatible",
  save.path = "",
  measure.times,
  kernel.function = gaussian.kernel
)
}
\arguments{
\item{dataset}{The dataset to be smoothed as a data.frame.}

\item{dependent.variable}{String name of the column in dataset with the dependent variable (defaults to "dependent.variable"); this column should be numeric or factor.}

\item{time}{String name of the column in dataset with the time variable (defaults to "year").}

\item{weight}{String name of column in the dataset with numeric weights (defaults to "weight").}

\item{bandwidth}{Numeric bandwidth of the kernel function.}

\item{sample.density.threshold}{Numeric local density of samples below which no estimates will be returned.}

\item{length.out}{The number of measure points along the time axis (defaults to 1000).}

\item{alpha}{Numeric alpha for calculating error margins (defaults to 0.05).}

\item{xlabel}{String label for the x-axis in returned plot (defaults to "year").}

\item{ylabel}{String label for the y-axis in returned plot.}

\item{greyscale}{If TRUE, plot will be in greyscale; if "compatible", plot will use a colour spectrum which also goes light>dark; otherwise, will use a non-greyscale-compatible colour scale.}

\item{save.path}{String path to save plot to (if not given, plot will not be saved).}

\item{measure.times}{A numeric vector of specific times at which to make estimates; if given, sample.density.threshold and length.out will be ignored.}

\item{kernel.function}{The kernel function, one of gaussian.kernel, gaussian.square.kernel, triangular.kernel, square.kernel, or a custom function.}
}
\value{
A list containing a data.frame with the smoothed estimates, and a ggplot grob visualising them.
}
\description{
This function performs kernel smoothing on a dataset in time alone.
}
\examples{
n=1000;
synthesised.data<-data.frame(x=stats::runif(n),y=stats::runif(n),
    year=stats::runif(n,0,sqrt(2)));
synthesised.data$dependent.variable<-unlist(lapply(1:nrow(synthesised.data),
    function(X){
    stats::dist(as.matrix(synthesised.data[c(1,X),1:2]),method =
    "euclidean")<synthesised.data$year[X];
}))
result<-kernelPhil::kernel.smooth.in.time(dataset = synthesised.data,
    bandwidth = 0.05,sample.density.threshold = 100);
result$plot;
}
